<?php

defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
/** @var object $job */

?>
<?php
init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-8 col-md-offset-2">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4 class="no-margin">
                            <i class="fa fa-calendar-plus-o"></i>
							<?php
							echo _l('submit_daily_log'); ?>
                        </h4>
                        <hr class="hr-panel-heading"/>

                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> <?php
							echo _l('daily_log_description'); ?>
                        </div>

						<?php
						echo form_open_multipart(admin_url('trade_job_management/jobs/handle_ajax_submit_daily_log'), ['id' => 'daily-log-form', 'class' => 'dropzone dropzone-manual']); ?>
                        <input type="hidden" name="job_id" value="<?php
						echo $job->jobid; ?>">

                        <div class="form-group">
                            <label for="log_date" class="control-label">
								<?php
								echo _l('log_date'); ?>
                            </label>
							<?php
							echo render_date_input('log_date', '', date('Y-m-d')); ?>
                        </div>

                        <div class="form-group">
                            <label for="comments" class="control-label">
								<?php
								echo _l('work_comments'); ?>
                            </label>
							<?php
							echo render_textarea('comments', '', '', ['rows' => 8]); ?>
                        </div>

                        <hr class="hr-panel-heading"/>
                        <div class="form-group">
                            <div class="checkbox checkbox-primary">
                                <input type="checkbox" name="is_visible_to_customer" id="is_visible_to_customer" value="1" checked>
                                <label for="is_visible_to_customer">
									<?php
									echo _l('visible_to_customer'); ?>
                                </label>
                            </div>
                            <p class="text-muted">
                                <small><?php
									echo _l('internal_only'); ?> - <?php
									echo _l('daily_log_visibility'); ?></small>
                            </p>
                        </div>

                        <h5><?php
							echo _l('upload_photos'); ?></h5>
                        <div id="dropzoneJobDailyLog" class="dropzoneDragArea dz-default dz-message task-comment-dropzone">
                            <span><?= _l('drop_files_here_to_upload'); ?></span>
                        </div>
                        <div class="dropzone-job-daily-log-previews dropzone-previews"></div>
                        <hr class="hr-panel-heading"/>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-check"></i> <?php
								echo _l('submit'); ?>
                            </button>
                            <a href="<?php
							echo admin_url('trade_job_management/jobs/daily_logs/'.$job->jobid); ?>" class="btn btn-default">
                                <i class="fa fa-times"></i> <?php
								echo _l('cancel'); ?>
                            </a>
                        </div>
						<?php
						echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
init_tail(); ?>

<script>
    $(function () {
        let jobDailyLogAttachmentDropzone;
        Dropzone.autoDiscover = false;

        if (Dropzone.instances.length > 0) Dropzone.instances.forEach(dz => dz.destroy())

        if (typeof (jobDailyLogAttachmentDropzone) != 'undefined') {
            jobDailyLogAttachmentDropzone.destroy();
            jobDailyLogAttachmentDropzone = null;
        }

        appValidateForm($('#daily-log-form'), {
            log_date: 'required',
            comments: 'required'
        });

        $('#daily-log-form').on('submit', function (e) {
            e.preventDefault();
            if (jobDailyLogAttachmentDropzone.files.length === 0) {
                const data = $(this).serialize();
                const url = this.action;
                $.post(url, data).done(function (response) {
                    response = JSON.parse(response);
                    if (response.success === true) {
                        alert_float("success", response.message);
                    } else {
                        alert_float("warning", response.message);
                    }
                    setTimeout(function () {
                        window.location.href = '<?php echo admin_url('trade_job_management/jobs/daily_logs/'.$job->jobid) ?>'
                    }, 1500);
                });
            } else {
                jobDailyLogAttachmentDropzone.processQueue();
            }
        })

        jobDailyLogAttachmentDropzone = new Dropzone(
            "#daily-log-form",
            appCreateDropzoneOptions({
                uploadMultiple: true,
                clickable: "#dropzoneJobDailyLog",
                previewsContainer: ".dropzone-job-daily-log-previews",
                autoProcessQueue: false,
                addRemoveLinks: true,
                parallelUploads: 20,
                maxFiles: 20,
                paramName: "file",
                sending: function (file, xhr, formData) {
                    $('#daily-log-form button').attr('disabled');
                },
                success: function (files, response) {
                    if (
                        this.getUploadingFiles().length === 0 &&
                        this.getQueuedFiles().length === 0
                    ) {
                        alert_float("success", '<?php echo _l('daily_log_updated') ?>');
                        setTimeout(function () {
                            window.location.href = '<?php echo admin_url('trade_job_management/jobs/daily_logs/'.$job->jobid) ?>'
                        }, 1500);
                    }
                },
            })
        );

    });
</script>
</body>
</html>
