<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="_buttons">
					<?php if (is_admin()) { ?>
                        <a href="javascript:void(0)"
                           onclick="new_api_client();return false;"
                           class="btn btn-primary mright5 test pull-left display-block">
                            <i class="fa-regular fa-plus tw-mr-1"></i>
							<?php echo _l('new_tjm_client'); ?></a>
					<?php } ?>
                    <div class="visible-xs">
                        <div class="clearfix"></div>
                    </div>
                    <div id="vueApp" class="tw-inline pull-right tw-ml-0 sm:tw-ml-1.5">
                        <app-filters
                                id="<?php echo $table->id(); ?>"
                                view="<?php echo $table->viewName(); ?>"
                                :saved-filters="<?php echo $table->filtersJs(); ?>"
                                :available-rules="<?php echo $table->rulesJs(); ?>">
                        </app-filters>
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="panel_s tw-mt-2 sm:tw-mt-4">
                    <div class="panel-body">
                        <div class="panel-table-full">
							<?php $this->load->view('clients/table_html'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="api_client" tabindex="-1" role="dialog">
        <div class="modal-dialog">
			<?= form_open(admin_url(TRADE_JOB_MANAGEMENT_MODULE_NAME . '/clients/create'), ['id' => 'api_client_form']); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">
                        <span class="add-title"><?= _l('new_tjm_client'); ?></span>
                    </h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
							<?= render_input('client_name', _l('tjm_api_client_name')); ?>
							<?= render_input('client_ip', _l('tjm_api_client_accepted_ips'), '*', 'text'); ?>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default"
                            data-dismiss="modal"><?= _l('close'); ?></button>
                    <button type="submit" class="btn btn-primary"
                            data-loading-text="<?= _l('wait_text'); ?>"
                            data-autocomplete="off"
                            data-form="#api_client_form"><?= _l('submit'); ?></button>
                </div>
            </div><!-- /.modal-content -->
			<?= form_close(); ?>
        </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->
    <script>
        function new_api_client() {
            $("#api_client").modal("show");
        }
    </script>

</div>
<?php init_tail(); ?>
<script>
    $(function () {
        initDataTable('.table-api_clients', admin_url + 'trade_job_management/clients/table', [0], [0], {},
			<?php echo hooks()->apply_filters('api_clients_table_default_order', json_encode([2, 'asc'])); ?>);

        appValidateForm(
            $("#api_client_form"),
            {
                client_name: "required",
                client_ip: "required"
            },
            add_new_api_client
        );

        function add_new_api_client(form) {
            var data = $(form).serialize();
            var url = form.action;
            $.post(url, data).done(function (response) {
                response = JSON.parse(response);
                if (response.success == true) {
                    alert_float("success", response.message);
                } else if (response.message) {
                    alert_float("danger", response.message);
                }

                $(".table-api_clients").DataTable().ajax.reload(null, false);
                $("#api_client").modal("hide");
                $("#api_client_form")[0].reset()
                $("#api_client_form").find('button[type="submit"]').button("reset");
            });
            return false;
        }
    });
</script>
</body>

</html>
