<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Properties_model extends App_Model {

	public function add($data)
	{
		$data['created_at'] = date('Y-m-d H:i:s');

		if (isset($data['property_managements']))
		{
			$property_managements = $data['property_managements'];
			unset($data['property_managements']);
		}

		if ( ! isset($data['created_by']))
		{
			$data['created_by'] = is_staff_logged_in() ? get_staff_user_id() : NULL;
		}
		$this->db->insert(db_prefix().'tjm_properties', $data);
		$insert_id = $this->db->insert_id();
		if ($insert_id)
		{
			if (isset($property_managements))
			{
				$this->add_edit_managements($property_managements, $insert_id);
			}

			log_activity('New Property Created [ID: '.$insert_id.']');

			return $insert_id;
		}

		return FALSE;
	}

	public function get($id = '', $where = [])
	{
		$this->db->where($where);
		if (is_numeric($id))
		{
			$this->db->where('propertyid', $id);
			$property = $this->db->get(db_prefix().'tjm_properties')->row();
			if ($property)
			{
				$CI = &get_instance();
				$CI->load->model('landlords_model');
				$CI->load->model('property_types_model');

				$property->landlord_data = new StdClass();
				$property->landlord_data = $this->landlords_model->get($property->landlord_id);

				$property->property_type_data = new StdClass();
				$property->property_type_data = $this->property_types_model->get($property->property_type_id);

				$property->managements = $this->get_property_managements($property->propertyid, TRUE);

				$property            = hooks()->apply_filters('property_get', $property);
				$GLOBALS['property'] = $property;

				return $property;
			}

			return NULL;
		}

		$this->db->select(db_prefix().'tjm_properties.*,'.db_prefix().'tjm_property_types.type_name as property_type');
		$this->db->order_by('propertyid', 'desc');

		return $this->db->get(db_prefix().'tjm_properties')->result_array();
	}

	public function update($data, $id)
	{
		$data['updated_at'] = date('Y-m-d H:i:s');
		if (isset($data['property_managements']))
		{
			$property_managements = $data['property_managements'];
			unset($data['property_managements']);
		}

		$this->add_edit_managements($property_managements, $id);
		$data = hooks()->apply_filters('before_update_property', $data, $id);

		$this->db->where('propertyid', $id);
		$this->db->update(db_prefix().'tjm_properties', $data);

		if ($this->db->affected_rows() > 0)
		{
			log_activity('Project Updated [ID: '.$id.']');
			hooks()->do_action('after_update_property', $id);

			return TRUE;
		}

		return FALSE;
	}

	public function add_edit_managements($staffs, $id): bool
	{
		$affectedRows = 0;

		$new_property_managements_to_receive_email = [];
		$this->db->select('property_name,landlord_id');
		$this->db->where('propertyid', $id);
		$property = $this->db->get(db_prefix().'tjm_properties')->row();

		$property_name = $property->property_name;
		$landlord_id   = $property->landlord_id;

		$property_managements_in = $this->get_property_managements($id);
		if (sizeof($property_managements_in) > 0)
		{
			foreach ($property_managements_in as $property_member)
			{
				if (isset($property_managements))
				{
					if ( ! in_array($property_member['staff_id'], $property_managements))
					{
						$this->db->where('property_id', $id);
						$this->db->where('staff_id', $property_member['staff_id']);
						$this->db->delete(db_prefix().'tjm_property_managements');
						if ($this->db->affected_rows() > 0)
						{
							$affectedRows++;
						}
					}
				} else
				{
					$this->db->where('property_id', $id);
					$this->db->delete(db_prefix().'tjm_property_managements');
					if ($this->db->affected_rows() > 0)
					{
						$affectedRows++;
					}
				}
			}

			$notifiedUsers = [];
			foreach ($staffs as $staff_id)
			{
				$this->db->where('property_id', $id);
				$this->db->where('staff_id', $staff_id);
				$_exists = $this->db->get(db_prefix().'tjm_property_managements')->row();
				if ( ! $_exists)
				{
					if (empty($staff_id))
					{
						continue;
					}
					$this->db->insert(db_prefix().'tjm_property_managements', [
						'property_id' => $id,
						'staff_id'    => $staff_id,
					]);
					if ($this->db->affected_rows() > 0)
					{
						if ($staff_id != get_staff_user_id())
						{
							$notified                                    = add_notification([
								'fromuserid'      => get_staff_user_id(),
								'description'     => 'not_staff_added_as_property_member',
								'link'            => 'properties/view/'.$id,
								'touserid'        => $staff_id,
								'additional_data' => serialize([
									$property_name,
								]),
							]);
							$new_property_managements_to_receive_email[] = $staff_id;
							if ($notified)
							{
								$notifiedUsers[] = $staff_id;
							}
						}
						$affectedRows++;
					}
				}
			}
			pusher_trigger_notification($notifiedUsers);
		} else
		{
			$notifiedUsers = [];
			foreach ($staffs as $staff_id)
			{
				if (empty($staff_id))
				{
					continue;
				}
				$this->db->insert(db_prefix().'tjm_property_managements', [
					'property_id' => $id,
					'staff_id'    => $staff_id,
				]);
				if ($this->db->affected_rows() > 0)
				{
					if ($staff_id != get_staff_user_id())
					{
						$notified                                    = add_notification([
							'fromuserid'      => get_staff_user_id(),
							'description'     => 'not_staff_added_as_property_member',
							'link'            => 'properties/view/'.$id,
							'touserid'        => $staff_id,
							'additional_data' => serialize([
								$property_name,
							]),
						]);
						$new_property_managements_to_receive_email[] = $staff_id;
						if ($notifiedUsers)
						{
							$notifiedUsers[] = $staff_id;
						}
					}
					$affectedRows++;
				}
			}
			pusher_trigger_notification($notifiedUsers);
		}

		if (count($new_property_managements_to_receive_email) > 0)
		{
			$all_members = $this->get_property_managements($id);
			foreach ($all_members as $data)
			{
				if (in_array($data['staff_id'], $new_property_managements_to_receive_email))
				{
					//					send_mail_template('property_staff_added_as_member', $data, $id, $landlord_id);
				}
			}

			hooks()->do_action('after_property_staff_added_as_member', [
				'property_id'                               => $id,
				'new_property_managements_to_receive_email' => $new_property_managements_to_receive_email,
			]);
		}
		if ($affectedRows > 0)
		{
			return TRUE;
		}

		return FALSE;
	}

	private function _mark_all_property_jobs_as_completed($id)
	{
		$this->db->where('rel_type', 'property');
		$this->db->where('rel_id', $id);
		$this->db->update(db_prefix().'jobs', [
			'status'       => 5,
			'datefinished' => date('Y-m-d H:i:s'),
		]);
		$jobs = $this->get_jobs($id);
		foreach ($jobs as $job)
		{
			$this->db->where('job_id', $job['id']);
			$this->db->where('end_time IS NULL');
			$this->db->update(db_prefix().'jobstimers', [
				'end_time' => time(),
			]);
		}
		$this->log_activity($id, 'property_activity_marked_all_jobs_as_complete');
	}

	public function get_jobs($id, $where = [], $apply_restrictions = FALSE, $count = FALSE, $callback = NULL)
	{
		$has_permission                    = staff_can('view', 'jobs');
		$show_all_jobs_for_property_member = get_option('show_all_jobs_for_property_member');

		$select
			= implode(', ', prefixed_table_fields_array(db_prefix().'jobs'))
			  .','
			  .db_prefix()
			  .'milestones.name as milestone_name,
        (SELECT SUM(CASE
            WHEN end_time is NULL THEN '
			  .time()
			  .'-start_time
            ELSE end_time-start_time
            END) FROM '
			  .db_prefix()
			  .'jobstimers WHERE job_id='
			  .db_prefix()
			  .'jobs.id) as total_logged_time,
           '
			  .get_sql_select_job_assignees_ids()
			  .' as assignees_ids
        ';

		if ( ! is_client_logged_in() && is_staff_logged_in())
		{
			$select .= ',(SELECT staffid FROM '.db_prefix().'job_assigned WHERE jobid='.db_prefix().'jobs.id AND staffid='.get_staff_user_id().') as current_user_is_assigned';
		}

		if (is_client_logged_in())
		{
			$this->db->where('visible_to_client', 1);
		}

		$this->db->select($select);

		$this->db->join(db_prefix().'milestones', db_prefix().'milestones.id = '.db_prefix().'jobs.milestone', 'left');
		$this->db->where('rel_id', $id);
		$this->db->where('rel_type', 'property');
		if ($apply_restrictions == TRUE)
		{
			if ( ! is_client_logged_in() && ! $has_permission && $show_all_jobs_for_property_member == 0)
			{
				$this->db->where(
					'(
                    '
					.db_prefix()
					.'jobs.id IN (SELECT jobid FROM '
					.db_prefix()
					.'job_assigned WHERE staffid='
					.get_staff_user_id()
					.')
                    OR '
					.db_prefix()
					.'jobs.id IN(SELECT jobid FROM '
					.db_prefix()
					.'job_followers WHERE staffid='
					.get_staff_user_id()
					.')
                    OR is_public = 1
                    OR (addedfrom ='
					.get_staff_user_id()
					.' AND is_added_from_contact = 0)
                    )',
				);
			}
		}

		if (isset($where[db_prefix().'milestones.hide_from_customer']))
		{
			$this->db->group_start();
			$this->db->where(db_prefix().'milestones.hide_from_customer', $where[db_prefix().'milestones.hide_from_customer']);
			$this->db->or_where(db_prefix().'jobs.milestone', 0);
			$this->db->group_end();
			unset($where[db_prefix().'milestones.hide_from_customer']);
		}

		$this->db->where($where);

		// Milestones kanban order
		// Request is admin/properties/milestones_kanban
		if ($this->uri->segment(3) == 'milestones_kanban' | $this->uri->segment(3) == 'milestones_kanban_load_more')
		{
			$this->db->order_by('milestone_order', 'asc');
		} else
		{
			$orderByString = hooks()->apply_filters('property_jobs_array_default_order', 'FIELD(status, 5), duedate IS NULL ASC, duedate');
			$this->db->order_by($orderByString, '', FALSE);
		}

		if ($callback)
		{
			$callback();
		}

		if ($count == FALSE)
		{
			$jobs = $this->db->get(db_prefix().'jobs')->result_array();
		} else
		{
			$jobs = $this->db->count_all_results(db_prefix().'jobs');
		}

		$jobs = hooks()->apply_filters('get_properties_jobs', $jobs, [
			'property_id' => $id,
			'where'       => $where,
			'count'       => $count,
		]);

		return $jobs;
	}

	/**
	 * Simplified function to send non complicated email templates for property contacts
	 *
	 * @param  mixed  $id  property id
	 *
	 * @return boolean
	 */
	public function send_property_customer_email($id, $template)
	{
		$sent     = FALSE;
		$contacts = $this->clients_model->get_contacts_for_property_notifications($id, 'property_emails');

		foreach ($contacts as $contact)
		{
			if (send_mail_template($template, $id, $contact['userid'], $contact))
			{
				$sent = TRUE;
			}
		}

		if ($sent)
		{
			hooks()->do_action('after_property_customer_email_sent', [
				'property_id'    => $id,
				'email_template' => $template,
			]);
		}

		return $sent;
	}

	private function _notify_property_managements_status_change($id, $old_status, $new_status)
	{
		$members       = $this->get_property_managements($id);
		$notifiedUsers = [];
		foreach ($members as $member)
		{
			if ($member['staff_id'] != get_staff_user_id())
			{
				$notified = add_notification([
					'fromuserid'      => get_staff_user_id(),
					'description'     => 'not_property_status_updated',
					'link'            => 'properties/view/'.$id,
					'touserid'        => $member['staff_id'],
					'additional_data' => serialize([
						'<lang>property_status_'.$old_status.'</lang>',
						'<lang>property_status_'.$new_status.'</lang>',
					]),
				]);
				if ($notified)
				{
					array_push($notifiedUsers, $member['staff_id']);
				}
			}
		}
		pusher_trigger_notification($notifiedUsers);
	}

	public function get_property_managements($id, $with_name = FALSE)
	{
		if ($with_name)
		{
			$this->db->select('firstname,lastname,email,property_id,staff_id');
		} else
		{
			$this->db->select('email,property_id,staff_id');
		}
		$this->db->join(db_prefix().'staff', db_prefix().'staff.staffid='.db_prefix().'tjm_property_managements.staff_id');
		$this->db->where('property_id', $id);

		return $this->db->get(db_prefix().'tjm_property_managements')->result_array();
	}

	public function delete($property_id)
	{
		$this->db->where('propertyid', $property_id);
		$this->db->delete(db_prefix().'tjm_properties');

		return TRUE;
	}

	public function get_files($property_id)
	{
		if (is_client_logged_in())
		{
			$this->db->where('visible_to_customer', 1);
		}
		$this->db->where('property_id', $property_id);

		return $this->db->get(db_prefix().'property_files')->result_array();
	}

	public function mark_as($data)
	{
		$this->db->select('status');
		$this->db->where('propertyid', $data['property_id']);
		$old_status = $this->db->get(db_prefix().'tjm_properties')->row()->status;

		$this->db->where('propertyid', $data['property_id']);
		$this->db->update(db_prefix().'tjm_properties', [
			'status' => $data['status_id'],
		]);
		if ($this->db->affected_rows() > 0)
		{
			hooks()->do_action('property_status_changed', [
				'status'      => $data['status_id'],
				'property_id' => $data['property_id'],
			]);

			if ($data['status_id'] == 4)
			{
				$this->log_activity($data['property_id'], 'property_marked_as_finished');
				$this->db->where('propertyid', $data['property_id']);
				$this->db->update(db_prefix().'tjm_properties', ['date_finished' => date('Y-m-d H:i:s')]);
			} else
			{
				$this->log_activity($data['property_id'], 'property_status_updated', '<b><lang>property_status_'.$data['status_id'].'</lang></b>');
				if ($old_status == 4)
				{
					$this->db->where('propertyid', $data['property_id']);
					$this->db->update(db_prefix().'tjm_properties', ['date_finished' => NULL]);
				}
			}

			if ($data['notify_property_managements_status_change'] == 1)
			{
				$this->_notify_property_managements_status_change($data['property_id'], $old_status, $data['status_id']);
			}

			if ($data['mark_all_jobs_as_completed'] == 1)
			{
				$this->_mark_all_property_jobs_as_completed($data['property_id']);
			}

			if (isset($data['cancel_recurring_jobs']) && $data['cancel_recurring_jobs'] == 'true')
			{
				$this->cancel_recurring_jobs($data['property_id']);
			}

			if (isset($data['send_property_marked_as_finished_email_to_contacts']) && $data['send_property_marked_as_finished_email_to_contacts'] == 1)
			{
				$this->send_property_customer_email($data['property_id'], 'property_marked_as_finished_to_customer');
			}

			return TRUE;
		}

		return FALSE;
	}

	public function is_member($property_id, $staff_id = '')
	{
		if ( ! is_numeric($staff_id))
		{
			$staff_id = get_staff_user_id();
		}
		$member = total_rows(db_prefix().'tjm_property_managements', [
			'staff_id'    => $staff_id,
			'property_id' => $property_id,
		]);
		if ($member > 0)
		{
			return TRUE;
		}

		return FALSE;
	}

	public function remove_team_member($property_id, $staff_id)
	{
		$this->db->where('property_id', $property_id);
		$this->db->where('staff_id', $staff_id);
		$this->db->delete(db_prefix().'tjm_property_managements');
		if ($this->db->affected_rows() > 0)
		{
			// Remove member from jobs where is assigned
			$this->db->where('staffid', $staff_id);
			$this->db->where('jobid IN (SELECT id FROM '.db_prefix().'jobs WHERE rel_type="property" AND rel_id="'.$this->db->escape_str($property_id).'")');
			$this->db->delete(db_prefix().'job_assigned');

			$this->log_activity($property_id, 'property_activity_removed_team_member', get_staff_full_name($staff_id));

			return TRUE;
		}

		return FALSE;
	}

	/**
	 * Get all property attachments
	 *
	 * @param  mixed  $property_id  jobid
	 *
	 * @return array
	 */
	public function get_property_attachments($property_id)
	{
		$this->db->where(db_prefix().'files.rel_id', $property_id);
		$this->db->where(db_prefix().'files.rel_type', 'property');

		$this->db->order_by(db_prefix().'files.dateadded', 'desc');

		return $this->db->get(db_prefix().'files')->result_array();
	}

	public function get_distinct_property_managements()
	{
		return $this->db
			->query(
				'SELECT staff_id, firstname, lastname FROM '
				.db_prefix()
				.'tjm_property_managements JOIN '
				.db_prefix()
				.'staff ON '
				.db_prefix()
				.'staff.staffid='
				.db_prefix()
				.'tjm_property_managements.staff_id GROUP by staff_id order by firstname ASC',
			)
			->result_array();
	}

	public function search_properties($q, $limit = 0)
	{
		$result = [
			'result'         => [],
			'type'           => 'property',
			'search_heading' => _l('properties'),
		];

		if (staff_can('view', 'project'))
		{
			$this->db->select(db_prefix().'tjm_properties.*,type_name');
			$this->db->join(db_prefix().'tjm_property_types', db_prefix().'tjm_property_types.propertytypeid='.db_prefix().'tjm_properties.property_type_id');
			$this->db->like('property_name', $q);
			$this->db->or_like('property_address', $q);
			$this->db->or_like('description', $q);
			if ($limit != 0)
			{
				$this->db->limit($limit);
			}
			$this->db->order_by('property_name', 'ASC');

			$result['result'] = $this->db->get(db_prefix().'tjm_properties')->result_array();
		}

		return $result;
	}

}
