<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Api_clients_model extends App_Model
{
    /**
     * Get task by id
     * @param mixed $id task id
     * @return object
     */
    public function get($id, $where = [])
    {
        $is_admin = is_admin();
        $this->db->where('id', $id);
        $this->db->where($where);
        $client = $this->db->get(db_prefix() . 'tjm_api_clients')->row();

        return hooks()->apply_filters('get_tjm_api_client', $client);
    }

    public function add($data)
    {
        $data = array_merge($data, [
            'client_id' => $this->generate_random_string(),
            'client_secret' => $this->generate_random_string(),
            'created_at' => date('Y-m-d H:i:s'),
        ]);
        if (!isset($data['client_ip'])) {
            $data['client_ip'] = '*';
        }

        $this->db->insert(db_prefix() . 'tjm_api_clients', $data);

        return $this->db->insert_id();
    }

    private function generate_random_string($length = 16)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';

        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }

        return $randomString;
    }

    public function delete($id)
    {
        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'tjm_api_clients');

        return $this->db->affected_rows() > 0;
    }
}
