<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_120 extends App_module_migration
{
    protected $module_name = 'trade_job_management';
    protected int $version = 120;

    public function up()
    {
        $this->ci->db->query(
            "INSERT INTO `tblemailtemplates` (`type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES
('jobs', 'job-status-change-to-contacts', 'english', 'Job Status Changed (Sent to Customer Contacts)', 'Job Status Changed', '<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /> <br /><span style=\"font-size: 12pt;\"><strong>{job_user_take_action}</strong> marked job as <strong>{job_status}</strong></span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Name:</strong> {job_name}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the job on the following link: <a href=\"{job_link}\">{job_name}</a></span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
('jobs', 'job-status-change-to-staff', 'english', 'Job Status Changed (Sent to Staff)', 'Job Status Changed', '<span style=\"font-size: 12pt;\">Hi {staff_firstname} {staff_lastname}</span><br /> <br /><span style=\"font-size: 12pt;\"><strong>{job_user_take_action}</strong> marked job as <strong>{job_status}</strong></span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Name:</strong> {job_name}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the job on the following link: <a href=\"{job_link}\">{job_name}</a></span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);",
        );

        zegaware_add_migration_log($this->module_name, $this->version);
    }

    public function down()
    {
        $this->ci->db->query("DELETE FROM `tblemailtemplates` WHERE `type` = 'jobs'");
        zegaware_delete_migration_log($this->module_name, $this->version);
    }

    

    
}
