<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_106 extends App_module_migration
{
    protected $module_name = 'trade_job_management';
    protected int $version = 106;

    public function up()
    {
        if ($this->ci->db->field_exists('property_address', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` DROP COLUMN `property_address`');
        }
        if ($this->ci->db->field_exists('job_property_type', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` DROP COLUMN `job_property_type`');
        }

        zegaware_add_migration_log($this->module_name, $this->version);
    }

    

    public function down()
    {
        if (!$this->ci->db->field_exists('property_address', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` ADD `property_address` VARCHAR(255)');
        }
        if (!$this->ci->db->field_exists('job_property_type', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` ADD `job_property_type` VARCHAR(255)');
        }

        zegaware_delete_migration_log($this->module_name, $this->version);
    }

    
}
