<?php

defined('BASEPATH') or exit('No direct script access allowed');

return App_table::find('properties')
    ->outputUsing(function ($params) {
        extract($params);

        $aColumns = [
            db_prefix() . 'tjm_properties.propertyid as id',
            'property_name',
            'property_address',
            'landlord_id',
            'type_name as property_type',
            db_prefix() . 'tjm_properties.status as status',
            db_prefix() . 'tjm_properties.created_at as created_at',
            '(SELECT GROUP_CONCAT(CONCAT(firstname, \' \', lastname) SEPARATOR ",") FROM '
            . db_prefix()
                . 'tjm_property_managements JOIN '
                . db_prefix()
                . 'staff on '
                . db_prefix()
                . 'staff.staffid = '
                . db_prefix()
                . 'tjm_property_managements.staff_id WHERE property_id='
                . db_prefix()
                . 'tjm_properties.propertyid ORDER BY staff_id) as members',
            'CONCAT(' . db_prefix() . 'tjm_landlords.first_name, \' \', ' . db_prefix() . 'tjm_landlords.last_name) as landlord_name',
        ];

        $sIndexColumn = 'id';
        $sTable = db_prefix() . 'tjm_properties';

        $join = [
            'JOIN ' . db_prefix() . 'tjm_property_types ON ' . db_prefix() . 'tjm_property_types.propertytypeid = ' . db_prefix() . 'tjm_properties.property_type_id',
            'JOIN ' . db_prefix() . 'tjm_landlords ON ' . db_prefix() . 'tjm_landlords.landlordid = ' . db_prefix() . 'tjm_properties.landlord_id',
        ];

        $where = [];

        if ($filtersWhere = $this->getWhereFromRules()) {
            $where[] = $filtersWhere;
        }

        if ($clientid != '') {
            array_push($where, ' AND landlord_id=' . $this->ci->db->escape_str($clientid));
        }

        if (staff_cant('view', 'tjm_properties')) {
            array_push($where, ' AND ' . db_prefix() . 'tjm_properties.propertyid IN (SELECT property_id FROM ' . db_prefix() . 'tjm_property_managements WHERE staff_id=' . get_staff_user_id() . ')');
        }

        $aColumns = hooks()->apply_filters('tjm_properties_table_sql_columns', $aColumns);

        $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
            'landlordid',
            '(SELECT GROUP_CONCAT(staff_id SEPARATOR ",") FROM ' . db_prefix() . 'tjm_property_managements WHERE property_id=' . db_prefix() . 'tjm_properties.propertyid ORDER BY staff_id) as members_ids',
        ]);

        $output = $result['output'];
        $rResult = $result['rResult'];

        foreach ($rResult as $aRow) {
            $row = [];

            $link = admin_url('trade_job_management/properties/view/' . $aRow['id']);

            $row[] = '<a href="' . $link . '">' . $aRow['id'] . '</a>';

            $name = '<a href="' . $link . '">' . e($aRow['property_name']) . '</a>';

            $name .= '<div class="row-options">';

            $name .= '<a href="' . $link . '">' . _l('view') . '</a>';
            $name .= ' | <a href="' . admin_url('trade_job_management/properties/edit/' . $aRow['id']) . '">' . _l('edit') . '</a>';
            $name .= ' | <a href="' . admin_url('trade_job_management/properties/delete/' . $aRow['id']) . '" class="text-danger _delete">' . _l('delete') . '</a>';

            $name .= '</div>';
            $row[] = $name;

            $row[] = '<a href="' . admin_url('trade_job_management/landlords/show/' . $aRow['landlord_id']) . '">' . e($aRow['landlord_name']) . '</a>';

            $row[] = $aRow['property_address'];
            $row[] = $aRow['property_type'];

            $membersOutput = '<div class="tw-flex -tw-space-x-1">';
            $members = explode(',', $aRow['members'] ?? '');
            $exportMembers = '';
            foreach ($members as $key => $member) {
                if ($member != '') {
                    $members_ids = explode(',', $aRow['members_ids']);
                    $member_id = $members_ids[$key];
                    $membersOutput .=
                        '<a href="'
                        . admin_url('profile/' . $member_id)
                        . '">'
                        . staff_profile_image(
                            $member_id,
                            [
                                'tw-inline-block tw-h-7 tw-w-7 tw-rounded-full tw-ring-2 tw-ring-white',
                            ],
                            'small',
                            [
                                'data-toggle' => 'tooltip',
                                'data-title' => $member,
                            ],
                        )
                        . '</a>';
                    // For exporting
                    $exportMembers .= $member . ', ';
                }
            }

            $membersOutput .= '<span class="hide">' . trim($exportMembers, ', ') . '</span>';
            $membersOutput .= '</div>';
            $row[] = $membersOutput;

            $date_created = $aRow['created_at'];
            $date_created = DateTime::createFromFormat('Y-m-d H:i:s', $date_created);

            $row[] = e($date_created->format('d-m-Y'));

            $row['DT_RowClass'] = 'has-row-options';

            $output['aaData'][] = $row;
        }

        return $output;
    })
    ->setRules([
        App_table_filter::new('name', 'TextRule')->label(_l('project_name')),
        App_table_filter::new('project_created', 'DateRule')->label(_l('project_created')),
        App_table_filter::new('members', 'MultiSelectRule')
            ->label(_l('project_members'))
            ->isVisible(fn() => staff_can('view', 'tjm_properties'))
            ->options(function ($ci) {
                return collect($ci->properties_model->get_distinct_property_managements())->map(function ($staff) {
                    return [
                        'value' => $staff['staff_id'],
                        'label' => get_staff_full_name($staff['staff_id']),
                    ];
                })->all();
            })
            ->raw(function ($value, $operator, $sqlOperator) {
                $dbPrefix = db_prefix();
                $sqlOperator = $sqlOperator['operator'];

                return "({$dbPrefix}tjm_properties.propertyid IN (SELECT property_id FROM {$dbPrefix}tjm_property_managements WHERE staff_id $sqlOperator ('" . implode("','", $value) . "')))";
            }),
    ]);
