<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div id="">
            <div class="row">
                <div class="col-md-12">
                    <div class="_buttons tw-mb-2 sm:tw-mb-4">
						<?php if (staff_can('create', 'projects')) { ?>
                            <a href="javascript:void(0);"
                               onclick="new_property_type()"
                               class="btn btn-primary pull-left display-block mright5">
                                <i class="fa-regular fa-plus tw-mr-1"></i>
								<?php echo _l('new_property_type'); ?>
                            </a>
						<?php } ?>
                        <div class="clearfix"></div>
                    </div>
                    <div class="panel_s tw-mt-2 sm:tw-mt-4">
                        <div class="panel-body">
                            <div class="row mbot15">
                                <div class="col-md-12">
                                    <h4 class="tw-mt-0 tw-font-semibold tw-text-lg tw-flex tw-items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                             stroke-width="1.5" stroke="currentColor"
                                             class="tw-w-5 tw-h-5 tw-text-neutral-500 tw-mr-1.5">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                  d="M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m0 12.75h7.5m-7.5 3H12M10.5 2.25H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z"/>
                                        </svg>
                                        <span>
                                            <?php echo _l('property_types_summary'); ?>
                                        </span>
                                    </h4>
                                </div>
                            </div>
                            <hr class="hr-panel-separator"/>
                            <div class="panel-table-full">
                                <div class="table-responsive">
									<?php
									$this->load->view(TRADE_JOB_MANAGEMENT_MODULE_NAME . '/property_types/property_type');
									?>
                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th class="text-nowrap"><b><?php echo _l('property_type_name'); ?></b></th>
                                            <th class="text-nowrap"><b><?php echo _l('property_type_status'); ?></b></b></th>
                                            <th class="text-nowrap"></th>
                                        </tr>
                                        </thead>
                                        <tbody>
										<?php foreach ($property_types as $property_type): ?>
                                            <tr>
                                                <td class="text-nowrap"><span class="label"><?php echo $property_type['type_name'] ?></span>
                                                </td>
                                                <td class="text-nowrap">
                                                    <div style="margin-right: 1rem; display: inline-block; min-width: 20px; width: 20px; height: 20px; background-color:<?php echo $property_type['bg_color'] ?>;">&nbsp;
                                                    </div><?php echo $property_type['bg_color'] ?>
                                                </td>
                                                <td class="text-nowrap">
                                                    <a class="label label-success"
                                                       data-id="<?php echo $property_type['propertytypeid'] ?>"
                                                       data-name="<?php echo $property_type['type_name'] ?>"
                                                       data-status="<?php echo $property_type['status'] ?>"
                                                       onclick="edit_property_type(this, '<?php echo $property_type['propertytypeid'] ?>')"
                                                       href="javascript:void(0)"><?php echo _l('edit') ?></a>
                                                    <a class="label label-danger" onclick="delete_property_type('<?php echo $property_type['propertytypeid'] ?>')"
                                                       href="javascript:void(0)"><?php echo _l('delete') ?></a>
                                                </td>
                                            </tr>
										<?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>


</script>
</body>
</html>
