<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<h4 class="mbot25"><?php echo $landlord->first_name . ' ' . $landlord->last_name ?> - Profile</h4>
<div class="row">
    <div class="col-md-12">
        <div class="row">
			<?php echo
    
			form_open($this->uri->uri_string(), ['class' => 'client-form', 'autocomplete' => 'off'])

			; ?>
            <div class="col-md-12">
				<?php $attrs = ['required' => true]; ?>
				<?php echo render_input('first_name', 'landlord_firstname', $landlord->first_name, 'text', $attrs); ?>
				<?php echo render_input('last_name', 'landlord_lastname', $landlord->last_name, 'text', $attrs); ?>
				<?php echo render_input('phone_number', 'landlord_phone', $landlord->phone_number, 'tel', $attrs); ?>
				<?php echo render_input('email', 'landlord_email', $landlord->email, 'email', $attrs); ?>
				<?php echo
    
				render_select('client_id', $clients, ['userid', 'company'], 'client', $landlord->client_id, ['data-none-selected-text' => _l('dropdown_non_selected_tex')])

				; ?>

                <div class="form-group">
                    <label for="website"><?php echo _l('client_website'); ?></label>
                    <div class="input-group">
                        <input type="text" name="website" id="website" value="<?php echo e($landlord->website); ?>"
                               class="form-control">
                        <span class="input-group-btn">
                                <a href="<?php echo e(maybe_add_http($landlord->website)); ?>" class="btn btn-default"
                                   target="_blank" tabindex="-1"><i class="fa fa-globe"></i></a>
                        </span>
                    </div>
                </div>
                <hr/>
				<?php $value = isset($landlord) ? $landlord->address : ''; ?>
				<?php echo render_textarea('address', 'client_address', $value); ?>
				<?php $value = isset($landlord) ? $landlord->city : ''; ?>
				<?php echo render_input('city', 'client_city', $value); ?>
				<?php $value = isset($landlord) ? $landlord->state : ''; ?>
				<?php echo render_input('state', 'client_state', $value); ?>
				<?php $value = isset($landlord) ? $landlord->zip_code : ''; ?>
				<?php echo render_input('zip_code', 'client_postal_code', $value); ?>
				<?php $countries = get_all_countries();



				$customer_default_country = get_option('customer_default_country');



				$selected = isset($landlord) ? $landlord->country : $customer_default_country;



				echo
    
				render_select('country', $countries, ['country_id', ['short_name']], 'clients_country', $selected, ['data-none-selected-text' => _l('dropdown_non_selected_tex')])

				;



				?>
            </div>
			<?php echo form_close() ?>
        </div>
    </div>
    <div class="clearfix"></div>
</div>
<script>

    window.addEventListener('load', function () {
        appValidateForm($('.client-form'), {
            first_name: 'required',
            last_name: 'required',
            phone_number: 'required',
            email: 'required',
        });
    });

</script>
