<?php

defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
/** @var object $job */

?>
<div class="modal fade" tabindex="-1" role="dialog" id="identityConfirmationModal">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
			<?= form_open(($formAction ?? $this->uri->uri_string()), ['id' => 'jobConfirmationForm', 'class' => 'form-horizontal']); ?>
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-check-circle"></i>
					<?= _l('job_confirmation'); ?> &amp;
					<?= _l('signature'); ?>
                </h4>
            </div>

            <div class="modal-body">
				<?php
				hooks()->do_action('before_job_confirmation_fields'); ?>

				<?php
				if (isset($formData))
				{
					echo $formData;
				} ?>

                <div id="job_confirmation_fields">
                    <!-- Name Field -->
                    <div class="form-group">
                        <label for="confirmation_firstname" class="control-label col-sm-3">
                            <span class="text-left inline-block full-width">
                                <?= _l('client_firstname'); ?>
                            </span>
                        </label>
                        <div class="col-sm-9">
                            <input type="text" name="confirmation_firstname" id="confirmation_firstname"
                                   class="form-control" required="true"
                                   value="<?= isset($job->landlord) ? e($job->landlord['first_name']) : '' ?>"
                                   placeholder="<?= _l('client_firstname'); ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="confirmation_lastname" class="control-label col-sm-3">
                            <span class="text-left inline-block full-width">
                                <?= _l('client_lastname'); ?>
                            </span>
                        </label>
                        <div class="col-sm-9">
                            <input type="text" name="confirmation_lastname" id="confirmation_lastname"
                                   class="form-control" required="true"
                                   value="<?= isset($job->landlord) ? e($job->landlord['last_name']) : '' ?>"
                                   placeholder="<?= _l('client_lastname'); ?>">
                        </div>
                    </div>

                    <!-- Email Field -->
                    <div class="form-group">
                        <label for="confirmation_email" class="control-label col-sm-3">
                            <span class="text-left inline-block full-width">
                                <?= _l('client_email'); ?>
                            </span>
                        </label>
                        <div class="col-sm-9">
                            <input type="email" name="confirmation_email" id="confirmation_email"
                                   class="form-control" required="true"
                                   value="<?= isset($job->landlord) ? e($job->landlord['email']) : '' ?>"
                                   placeholder="<?= _l('client_email'); ?>">
                        </div>
                    </div>

                    <!-- Feedback Field -->
                    <div class="form-group">
                        <label for="confirmation_feedback" class="control-label col-sm-3">
                            <span class="text-left inline-block full-width">
                                <?= _l('job_feedback'); ?>
                            </span>
                        </label>
                        <div class="col-sm-9">
                            <textarea name="confirmation_feedback" id="confirmation_feedback"
                                      class="form-control" rows="4"
                                      placeholder="<?= _l('job_your_feedback'); ?>"></textarea>
                            <small class="form-text text-muted">
								<?= _l('job_your_feedback'); ?>
                            </small>
                        </div>
                    </div>

                    <!-- Signature Label and Canvas -->
                    <div class="form-group">
                        <label class="control-label col-sm-3">
                            <span class="text-left inline-block full-width">
                                <?= _l('signature'); ?>
                            </span>
                        </label>
                        <div class="col-sm-9">
                            <p class="bold tw-text-lg" id="signatureLabel">
								<?= _l('signature'); ?>
                            </p>
                        </div>
                    </div>

                    <!-- Signature Canvas -->
                    <div class="form-group">
                        <div class="col-sm-12">
                            <div class="signature-pad--body" style="min-width: 100%;">
                                <canvas id="signature" height="200" width="550"></canvas>
                            </div>
                            <input type="text" style="width:1px; height:1px; border:0px;"
                                   tabindex="-1" name="signature" id="signatureInput">
                            <div class="display-block mtop15">
                                <button type="button" class="btn btn-default btn-xs clear"
                                        tabindex="-1" data-action="clear">
                                    <i class="fa fa-eraser"></i> <?= _l('clear'); ?>
                                </button>
                                <button type="button" class="btn btn-default btn-xs"
                                        tabindex="-1" data-action="undo">
                                    <i class="fa fa-undo"></i> <?= _l('undo'); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

				<?php
				hooks()->do_action('after_job_confirmation_fields'); ?>
            </div>

            <!-- Modal Footer -->
            <div class="modal-footer">
                <p class="text-left text-muted e-sign-legal-text">
					<?= _l(get_option('e_sign_legal_text'), '', FALSE); ?>
                </p>
                <hr/>
                <button type="button" class="btn btn-default" data-dismiss="modal">
					<?= _l('cancel'); ?>
                </button>
                <button type="submit" data-loading-text="<?= _l('wait_text'); ?>"
                        autocomplete="off" data-form="#jobConfirmationForm"
                        class="btn btn-success">
                    <i class="fa fa-check"></i> <?= _l('confirm_and_sign'); ?>
                </button>
            </div>

			<?= form_close(); ?>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<?php
$this->app_scripts->theme('signature-pad', 'assets/plugins/signature-pad/signature_pad.min.js');
?>

<script>
    $(function () {
        // Signature Pad Configuration
        SignaturePad.prototype.toDataURLAndRemoveBlanks = function () {
            var canvas = this._ctx.canvas;
            // First duplicate the canvas to not alter the original
            var croppedCanvas = document.createElement('canvas'),
                croppedCtx = croppedCanvas.getContext('2d');

            croppedCanvas.width = canvas.width;
            croppedCanvas.height = canvas.height;
            croppedCtx.drawImage(canvas, 0, 0);

            // Next do the actual cropping
            var w = croppedCanvas.width,
                h = croppedCanvas.height,
                pix = {
                    x: [],
                    y: []
                },
                imageData = croppedCtx.getImageData(0, 0, croppedCanvas.width, croppedCanvas.height),
                x, y, index;

            for (y = 0; y < h; y++) {
                for (x = 0; x < w; x++) {
                    index = (y * w + x) * 4;
                    if (imageData.data[index + 3] > 0) {
                        pix.x.push(x);
                        pix.y.push(y);
                    }
                }
            }
            pix.x.sort(function (a, b) {
                return a - b
            });
            pix.y.sort(function (a, b) {
                return a - b
            });
            var n = pix.x.length - 1;

            w = pix.x[n] - pix.x[0];
            h = pix.y[n] - pix.y[0];
            var cut = croppedCtx.getImageData(pix.x[0], pix.y[0], w, h);

            croppedCanvas.width = w;
            croppedCanvas.height = h;
            croppedCtx.putImageData(cut, 0, 0);

            return croppedCanvas.toDataURL();
        };

        // Handle signature pad changes
        function signaturePadChanged() {
            var input = document.getElementById('signatureInput');
            var $signatureLabel = $('#signatureLabel');
            $signatureLabel.removeClass('text-danger');

            if (signaturePad.isEmpty()) {
                $signatureLabel.addClass('text-danger');
                input.value = '';
                return false;
            }

            $('#signatureInput-error').remove();
            var partBase64 = signaturePad.toDataURLAndRemoveBlanks();
            partBase64 = partBase64.split(',')[1];
            input.value = partBase64;
        }

        // Initialize signature pad
        var canvas = document.getElementById("signature");
        var wrapper = document.querySelector('.signature-pad--body');
        var clearButton = document.querySelector("[data-action=clear]");
        var undoButton = document.querySelector("[data-action=undo]");
        var jobConfirmationForm = document.getElementById('jobConfirmationForm');

        var signaturePad = new SignaturePad(canvas, {
            maxWidth: 2,
            onEnd: function () {
                signaturePadChanged();
            }
        });

        // Clear button handler
        clearButton.addEventListener("click", function (event) {
            event.preventDefault();
            signaturePad.clear();
            signaturePadChanged();
        });

        // Undo button handler
        undoButton.addEventListener("click", function (event) {
            event.preventDefault();
            var data = signaturePad.toData();
            if (data) {
                data.pop(); // remove the last dot or line
                signaturePad.fromData(data);
                signaturePadChanged();
            }
        });

        // Form submission handler
        //$('#jobConfirmationForm').submit(function (e) {
        //    signaturePadChanged();
        //
        //    // Validate signature is not empty
        //    if (signaturePad.isEmpty()) {
        //        e.preventDefault();
        //        alert('<?php //= _l("signature_required"); ?>//');
        //        return false;
        //    }
        //});

        // Modal shown event - ensure canvas is properly sized
        $('#jobConfirmationModal').on('shown.bs.modal', function () {
            var canvas = document.getElementById('signature');
            if (canvas) {
                var wrapper = document.querySelector('.signature-pad--body');
                var rect = wrapper.getBoundingClientRect();
                canvas.width = wrapper.offsetWidth;
                canvas.height = 200;
            }
        });

        appValidateForm($('#jobConfirmationForm'), {
            confirmation_firstname: 'required',
            confirmation_lastname: 'required',
            confirmation_email: 'required',
            signature: 'required'
        });

    });
</script>
