<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Landlords_model extends App_Model {

	/**
	 * Get contact by given email
	 *
	 * @param  string  $email
	 *
	 * @return array|null
	 * @since 1.0.0
	 *
	 */
	public function get_landlord_by_email(string $email): null|array
	{
		$this->db->select('*');
		$this->db->where('email', $email);
		$this->db->limit(1);

		return $this->db->get('tjm_landlords')->row_array();
	}

	/**
	 * Get landlord object based on passed clientid if not passed clientid return array of all clients
	 *
	 * @param  mixed  $id  client id
	 * @param  array  $where
	 *
	 * @return mixed
	 */
	public function get($id = '', $where = [])
	{
		$this->db->select(implode(',', prefixed_table_fields_array(db_prefix().'tjm_landlords')));

		$this->db->join(db_prefix().'countries', ''.db_prefix().'countries.country_id = '.db_prefix().'tjm_landlords.country', 'left');

		if (is_array($where) && count($where) > 0 || is_string($where) && $where != '')
		{
			$this->db->where($where);
		}

		if (is_numeric($id))
		{
			$this->db->where(db_prefix().'tjm_landlords.landlordid', $id);
			$landlord = $this->db->get(db_prefix().'tjm_landlords')->row();

			return $landlord;
		}

		$this->db->order_by('first_name', 'asc');

		return $this->db->get(db_prefix().'tjm_landlords')->result_array();
	}

	/**
	 * @param  array  $_POST  data
	 *
	 * @return integer Insert ID
	 *
	 * Add new client to database
	 */
	public function add($data)
	{
		$created_by = $data['created_by'] ?? FALSE;
		if ( ! $created_by)
		{
			$created_by = is_staff_logged_in() ? get_staff_user_id() : NULL;
		}
		$this->db->insert(db_prefix().'tjm_landlords', array_merge($data, [
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $created_by,
		]));

		$landlord_id = $this->db->insert_id();

		return $landlord_id;
	}

	/**
	 * @param  integer  $id  ID
	 *
	 * @return boolean
	 * Delete client, also deleting rows from, dismissed client announcements, ticket replies, tickets, autologin, user notes
	 */
	public function delete($id)
	{
		hooks()->do_action('before_landlord_deleted', $id);

		$this->db->where('landlordid', $id);
		$this->db->delete(db_prefix().'tjm_landlords');

		log_activity('Landlord Deleted [ID: '.$id.']');

		return TRUE;
	}

	/**
	 * @param $id
	 * @param $client_id
	 *
	 * @return boolean
	 * Update client informations
	 */
	public function update_client_id($id, $client_id)
	{
		hooks()->do_action('before_landlord_updated', $id);

		$this->db->where('landlordid', $id);
		$this->db->update(db_prefix().'tjm_landlords', [
			'client_id' => $client_id,
		]);

		return $this->db->affected_rows() > 0;
	}

	/**
	 * @param $data
	 * @param $id
	 *
	 * @return boolean
	 * Update client informations
	 */
	public function update($data, $id)
	{
		hooks()->do_action('before_landlord_updated', $id);

		$this->db->where('landlordid', $id);
		$this->db->update(db_prefix().'tjm_landlords', $data);

		return $this->db->affected_rows() > 0;
	}

}
