<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_147 extends App_module_migration {

	protected $module_name = 'trade_job_management';
	protected int $version = 147;

	public function up()
	{
		zegaware_add_migration_log($this->module_name, $this->version);

		// Create daily logs table
		if ( ! $this->ci->db->table_exists(db_prefix().'tjm_job_daily_logs'))
		{
			$this->ci->db->query(
				'CREATE TABLE `'.db_prefix().'tjm_job_daily_logs` (
				`daily_log_id` INT(11) NOT NULL AUTO_INCREMENT,
				`job_id` INT(11) NOT NULL,
				`staff_id` INT(11) NOT NULL,
				`log_date` DATE NOT NULL,
				`comments` TEXT NOT NULL,
				`is_visible_to_customer` TINYINT(1) DEFAULT 1,
				`created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
				`updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
				PRIMARY KEY (`daily_log_id`),
				KEY `job_id` (`job_id`),
				KEY `staff_id` (`staff_id`),
				KEY `log_date` (`log_date`),
				KEY `job_date_idx` (`job_id`, `log_date`),
                CONSTRAINT `fk_job_daily_logs_staff` FOREIGN KEY (`staff_id`) REFERENCES `'.db_prefix().'staff` (`staffid`) ON DELETE CASCADE
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;',
			);
		}
	}

	public function down()
	{
		zegaware_delete_migration_log($this->module_name, $this->version);
		if ($this->ci->db->table_exists(db_prefix().'tjm_job_daily_logs'))
		{
			$this->ci->db->query('DROP TABLE `'.db_prefix().'tjm_job_daily_logs`');
		}
	}

}
