<?php

if (!function_exists('tjm_add_property_permissions')) {
    function tjm_add_property_permissions($core_permissions, $data): array
    {
        $core_permissions['property'] = [
            'name' => 'Property',
            'capabilities' => [
                'view' => 'View (Global)',
                'view_own' => 'View (Own)',
                'create' => 'Create',
                'edit' => 'Edit',
                'delete' => 'Delete',
            ],
        ];

        return $core_permissions;
    }

    hooks()->add_filter('staff_permissions', 'tjm_add_property_permissions', 10, 2);
}

if (!function_exists('tjm_add_job_permissions')) {
    function tjm_add_job_permissions($core_permissions, $data): array
    {
        $core_permissions['job'] = [
            'name' => 'Job',
            'capabilities' => [
                'view' => 'View (Global)',
                'view_own' => 'View (Own)',
                'create' => 'Create',
                'edit' => 'Edit',
                'delete' => 'Delete',
            ],
        ];

        return $core_permissions;
    }

    hooks()->add_filter('staff_permissions', 'tjm_add_job_permissions', 10, 2);
}

if (!function_exists('tjm_add_landlord_permissions')) {
    function tjm_add_landlord_permissions($core_permissions, $data): array
    {
        $core_permissions['landlord'] = [
            'name' => 'Landlord',
            'capabilities' => [
                'view' => 'View (Global)',
                'view_own' => 'View (Own)',
                'create' => 'Create',
                'edit' => 'Edit',
                'delete' => 'Delete',
            ],
        ];

        return $core_permissions;
    }

    hooks()->add_filter('staff_permissions', 'tjm_add_landlord_permissions', 10, 2);
}
