<?php

defined('BASEPATH') or exit('No direct script access allowed');
/* Declaring helper getSubDomain if not found (from constants.php on perfex update) */
if (!function_exists("getSubDomain")) {
    function getSubDomain()
    {
        $array = explode("\n", file_get_contents(APPPATH . "config/app-config.php"));
        $base_url_line = array_filter($array, function($line){
            return str_contains($line, "APP_BASE_URL");
        });
        reset($base_url_line);
        $pattern = "/'(https?:\/\/[^']+)'/";
        preg_match($pattern, reset($base_url_line), $matches);
        $base_url = $matches[1];

        $base_url = preg_replace("~^https?://~i", '', $base_url);
        $base_url = preg_replace("/^www\./i", '', $base_url);
        $base_url = rtrim($base_url, '/');

        $scheme          = $_SERVER['REQUEST_SCHEME'] ?? $_SERVER['HTTP_X_FORWARDED_PROTO'] ?? (('on' == strtolower($_SERVER['HTTPS'])) ? 'https' : 'http');
        $url             = $scheme."://{$_SERVER['HTTP_HOST']}".str_replace(basename($_SERVER['SCRIPT_NAME']), '', $_SERVER['SCRIPT_NAME']);

        $url = preg_replace("~^https?://~i", '', $url);
        $url = preg_replace("/^www\./i", '', $url);
        $url = rtrim($url, '/');

        $subDomain = rtrim(str_replace($base_url, "", $url), ".");
        return !empty($subDomain) ? $subDomain : false;
    }
}

if (empty(getSubDomain())) {
    $route['/'] = 'saas/pricing/index';
    $route['default_controller'] = 'saas/pricing/index';
    $route['404_override']         = 'saas/pricing/show_404';

    $route['ws/(:any)/ws/(:any)/admin'] = 'admin/dashboard';
    $route['ws/(:any)/ws/(:any)'] = 'clients';
    $route['ws/(:any)/ws/(:any)/(:any)'] = '$3';
    $route['ws/(:any)/ws/(:any)/(:any)/(:any)'] = '$3/$4';
    $route['ws/(:any)/ws/(:any)/(:any)/(:any)/(:any)'] = '$3/$4/$5';
    $route['ws/(:any)/ws/(:any)/(:any)/(:any)/(:any)/(:any)'] = '$3/$4/$5/$6';
    $route['ws/(:any)/ws/(:any)/(:any)/(:any)/(:any)/(:any)/(:any)'] = '$3/$4/$5/$6/$7';

    $route['ws/(:any)/admin'] = 'admin/dashboard';
    $route['ws/(:any)'] = 'clients';
    $route['ws/(:any)/(:any)'] = '$2';
    $route['ws/(:any)/(:any)/(:any)'] = '$2/$3';
    $route['ws/(:any)/(:any)/(:any)/(:any)'] = '$2/$3/$4';
    $route['ws/(:any)/(:any)/(:any)/(:any)/(:any)'] = '$2/$3/$4/$5';
    $route['ws/(:any)/(:any)/(:any)/(:any)/(:any)/(:any)'] = '$2/$3/$4/$5/$6';

    hooks()->add_action('after_contact_login', function () {
        $CI = &get_instance();
        if (!$CI->session->has_userdata('red_url'))
            $CI->session->set_userdata([
                'red_url' => site_url('clients/'),
            ]);
    });
}
