<script>
    (function($){
        // your original code wrapped into a function so we can call it on-demand
        function initGoogleGeoLeadInline() {
            (function($){
                // Insert inputs on DOM ready if required elements exist
                $(function() {
                    // Company search input
                    if ((parseInt(<?= (int)get_option('google_geo_lead') ?>) === 1) && $('#address').length) {
                        // only inject if not already present
                        if (!$('#search_address').length) {
                            var $addressGroup = $('#address').closest('.form-group');
                            var searchAddressHtml = `
                              <div class="form-group">
                                <label for="search_address" class="control-label"><?= _l('google_geo_search_address') ?></label>
                                <input type="text" id="search_address" class="form-control" autocomplete="off" />
                                <input type="hidden" id="latitude" />
                                <input type="hidden" id="longitude" />
                              </div>
                            `;
                            $addressGroup.before(searchAddressHtml);
                        }
                    }
                });

                // Initialize Autocomplete instances (callback for Google API)
                window.initAutocomplete = function() {
                    // Company autocomplete
                    var el = document.getElementById('search_address');
                    if (el) {
                        var autocomplete = new google.maps.places.Autocomplete(el, { types: ['geocode'] });
                        autocomplete.setFields(['address_components', 'geometry', 'formatted_address', 'place_id']);

                        autocomplete.addListener('place_changed', function() {
                            var place = autocomplete.getPlace();
                            if (!place || !place.geometry) {
                                return;
                            }

                            // Fill hidden lat/lng
                            if (place.geometry.location) {
                                var lat = place.geometry.location.lat();
                                var lng = place.geometry.location.lng();
                                var $lat = document.getElementById('latitude');
                                var $lng = document.getElementById('longitude');
                                if ($lat) $lat.value = lat;
                                if ($lng) $lng.value = lng;
                            }

                            // Populate address fields using your helper functions (must exist globally)
                            if (typeof setBuilding === 'function') setBuilding(place.address_components, '#address');
                            if (typeof setPostalCode === 'function') setPostalCode(place.address_components, '#zip');
                            if (typeof setState === 'function') setState(place.address_components, '#state');
                            if (typeof setCity === 'function') setCity(place.address_components, '#city');
                            if (typeof setArea === 'function') setArea(place.address_components, '#address');
                            if (typeof setCountry === 'function') setCountry(place.address_components, 'country');
                        });
                    }
                };

                // If Google API is already loaded and ready, call initAutocomplete now (safe guard)
                // This covers the case when the API script was included without callback or loaded earlier.
                function maybeCallInit() {
                    if (window.google && google.maps && typeof window.initAutocomplete === 'function') {
                        try { window.initAutocomplete(); } catch (e) { /* ignore */ }
                    }
                }
                // call on load and also after small delay (covers async load orders)
                $(window).on('load', maybeCallInit);
                setTimeout(maybeCallInit, 1000);
            })(jQuery);
        }

        // Run once on initial load (safe: the function checks for element existence and won't duplicate)
        $(function() {
            initGoogleGeoLeadInline();
        });

        // Re-run after relevant AJAX calls (Option 2)
        $(document).ajaxComplete(function(event, xhr, settings) {
            // adjust this condition to target the AJAX URL(s) you care about
            // common Perfex lead endpoints might include 'leads', 'leads/lead', etc.
            if (typeof settings.url === 'string' && (
                settings.url.indexOf('leads') !== -1 ||
                settings.url.indexOf('leads/lead') !== -1 ||
                settings.url.indexOf('leads/ajax') !== -1
            )) {
                // call the original script again so it injects inputs and re-inits autocomplete if needed
                initGoogleGeoLeadInline();
            }

            // Check if URL has a trailing numeric ID (e.g. leads/lead/1 or leads/lead/1/)
            // This regex captures the last numeric segment if present
            var match = settings.url.match(/\/(\d+)(?:\/)?(?:\?.*)?$/);
            if (match && match[1]) {
                var id = match[1];

                // Optional: limit to leads/lead path only (avoid matching other numeric URLs)
                // adjust this condition if your URL structure differs
                if (settings.url.indexOf('leads/lead') === -1 && settings.url.indexOf('leads/view') === -1) {
                    // not a leads/lead URL — skip
                    return;
                }

                var endpoint = '<?= admin_url("google_geo/get_lead_geo") ?>';

                $.ajax({
                    url: endpoint,
                    method: 'GET',
                    dataType: 'json',
                    data: {
                        id: id,
                        user_id: $('#assigned').val(),
                    },
                    success: function(resp) {
                        if (!resp) return;

                        // If server returned coordinates, populate fields
                        if (resp.latitude && resp.longitude) {
                            // update existing inputs if present
                            if ($('#latitude').length) $('#latitude').val(resp.latitude);
                            if ($('#longitude').length) $('#longitude').val(resp.longitude);
                        }

                        // You can also handle other returned fields here
                        console.debug('google_geo: server returned data for lead', id, resp);
                    },
                    error: function(xhr, status, err) {
                        console.warn('google_geo: failed to fetch lead geo for id ' + id + ': ' + status);
                    }
                });
            }
        });

    })(jQuery);
</script>
<script>
    (function($){
        // helper to parse query-string into object
        function parseQueryString(qs) {
            var obj = {};
            if (!qs) return obj;
            qs = qs.replace(/^\?/, '');
            qs.split('&').forEach(function(part) {
                if (!part) return;
                var kv = part.split('=');
                var key = decodeURIComponent(kv[0] || '');
                var val = decodeURIComponent(kv[1] || '');
                // handle multiple values (not required here)
                if (obj[key] !== undefined) {
                    if (!Array.isArray(obj[key])) obj[key] = [obj[key]];
                    obj[key].push(val);
                } else {
                    obj[key] = val;
                }
            });
            return obj;
        }

        // Try to find CSRF token inputs on the page (Perfex usually has them)
        function getCsrf() {
            var csrf = {};
            // common approach: a hidden input exists in forms
            var $csrfInput = $('input[name="<?= get_instance()->security->get_csrf_token_name(); ?>"]');
            if ($csrfInput.length) {
                csrf[ $csrfInput.attr('name') ] = $csrfInput.val();
            }
            return csrf;
        }

        $(document).ajaxSend(function(event, xhr, settings) {
            if (typeof settings.url !== 'string') return;

            // Adjust this check to match your exact lead-save AJAX endpoint(s)
            // Example possibilities: 'leads/update', 'leads/ajax', 'leads/lead'
            if (settings.url.indexOf('leads') === -1) return;

            // Extract data payload (settings.data may be string or object)
            var payload = {};
            if (typeof settings.data === 'string') {
                payload = parseQueryString(settings.data);
            } else if (typeof settings.data === 'object' && settings.data !== null) {
                payload = settings.data;
            }

            // If geo fields present, forward minimal payload to server to save in session
            console.log(payload);
            var forward = {
                user_id: $('#assigned').val(),
                latitude: $('#latitude').val() || '',
                longitude: $('#longitude').val() || ''
            };

            // If nothing usable, skip
            if (!!forward.latitude && !forward.longitude) return;

            // Merge CSRF token if exists
            var csrf = getCsrf();
            var postData = $.extend({}, forward, csrf);

            // POST to your module endpoint that will save into CI session
            $.post('<?= admin_url("google_geo/save_lead_pending") ?>', postData)
                .fail(function() {
                    console.warn('google_geo: failed to save pending geo payload to server.');
                });
        });
    })(jQuery);
</script>