<script>
    (function($){
        // Insert inputs on DOM ready if required elements exist
        $(function() {
            // Billing search input
            if ($('#billing_street').length) {
                if (!$('#billing_search_address').length) {
                    var $billingGroup = $('#billing_street').closest('.form-group');
                    var billingHtml = `
                                  <div class="form-group">
                                    <label for="billing_search_address" class="control-label"><?= _l('google_geo_search_address') ?></label>
                                    <input type="text" id="billing_search_address" name="billing_search_address" class="form-control" autocomplete="off" />
                                    <input type="hidden" id="billing_latitude" name="billing_latitude" />
                                    <input type="hidden" id="billing_longitude" name="billing_longitude" />
                                  </div>
                                `;
                    $billingGroup.before(billingHtml);
                }
            }

            // Shipping search input
            if ($('#shipping_street').length) {
                if (!$('#shipping_search_address').length) {
                    var $shippingGroup = $('#shipping_street').closest('.form-group');
                    var shippingHtml = `
                                  <div class="form-group">
                                    <label for="shipping_search_address" class="control-label"><?= _l('google_geo_search_address') ?></label>
                                    <input type="text" id="shipping_search_address" name="shipping_search_address" class="form-control" autocomplete="off" />
                                    <input type="hidden" id="shipping_latitude" name="shipping_latitude" />
                                    <input type="hidden" id="shipping_longitude" name="shipping_longitude" />
                                  </div>
                                `;
                    $shippingGroup.before(shippingHtml);
                }
            }
        });

        // Initialize Autocomplete instances (callback for Google API)
        window.initAutocomplete = function() {

            // Billing autocomplete
            var bel = document.getElementById('billing_search_address');
            if (bel) {
                var bAutocomplete = new google.maps.places.Autocomplete(bel, { types: ['geocode'] });
                bAutocomplete.setFields(['address_components', 'geometry', 'formatted_address', 'place_id']);

                bAutocomplete.addListener('place_changed', function() {
                    var place = bAutocomplete.getPlace();
                    if (!place || !place.geometry) {
                        return;
                    }

                    if (place.geometry.location) {
                        var blat = place.geometry.location.lat();
                        var blng = place.geometry.location.lng();
                        var $blat = document.getElementById('billing_latitude');
                        var $blng = document.getElementById('billing_longitude');
                        if ($blat) $blat.value = blat;
                        if ($blng) $blng.value = blng;
                    }

                    // Populate billing address fields using your helper functions
                    if (typeof setBuilding === 'function') setBuilding(place.address_components, '#billing_street');
                    if (typeof setPostalCode === 'function') setPostalCode(place.address_components, '#billing_zip');
                    if (typeof setState === 'function') setState(place.address_components, '#billing_state');
                    if (typeof setCity === 'function') setCity(place.address_components, '#billing_city');
                    if (typeof setArea === 'function') setArea(place.address_components, '#billing_street');
                    if (typeof setCountry === 'function') setCountry(place.address_components, 'billing_country');
                });
            }

            // Shipping autocomplete
            var shipel = document.getElementById('shipping_search_address');
            if (shipel) {
                var shipAutocomplete = new google.maps.places.Autocomplete(shipel, { types: ['geocode'] });
                shipAutocomplete.setFields(['address_components', 'geometry', 'formatted_address', 'place_id']);

                shipAutocomplete.addListener('place_changed', function() {
                    var place = shipAutocomplete.getPlace();
                    if (!place || !place.geometry) {
                        return;
                    }

                    if (place.geometry.location) {
                        var shiplat = place.geometry.location.lat();
                        var shiplng = place.geometry.location.lng();
                        var $shiplat = document.getElementById('shipping_latitude');
                        var $shiplng = document.getElementById('shipping_longitude');
                        if ($shiplat) $shiplat.value = shiplat;
                        if ($shiplng) $shiplng.value = shiplng;
                    }

                    // Populate shipping address fields using your helper functions
                    if (typeof setBuilding === 'function') setBuilding(place.address_components, '#shipping_street');
                    if (typeof setPostalCode === 'function') setPostalCode(place.address_components, '#shipping_zip');
                    if (typeof setState === 'function') setState(place.address_components, '#shipping_state');
                    if (typeof setCity === 'function') setCity(place.address_components, '#shipping_city');
                    if (typeof setArea === 'function') setArea(place.address_components, '#shipping_street');
                    if (typeof setCountry === 'function') setCountry(place.address_components, 'shipping_country');
                });
            }
        };

        // If Google API is already loaded and ready, call initAutocomplete now (safe guard)
        // This covers the case when the API script was included without callback or loaded earlier.
        function maybeCallInit() {
            if (window.google && google.maps && typeof window.initAutocomplete === 'function') {
                try { window.initAutocomplete(); } catch (e) { /* ignore */ }
            }
        }
        // call on load and also after small delay (covers async load orders)
        $(window).on('load', maybeCallInit);
        setTimeout(maybeCallInit, 1000);
    })(jQuery);
</script>