<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
			<?php echo
    			form_open_multipart($this->uri->uri_string(), ['id' => 'property_form'])
			; ?>
            <div class="col-md-8 col-md-offset-2">
                <h4 class="tw-mt-0 tw-font-semibold tw-text-lg tw-text-neutral-700">
					<?php echo e($title); ?>
                </h4>
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="tw-mt-3">
                            <div role="tabpanel" class="tab-pane active" id="tab_property">
								<?php echo render_input('property_name', 'property_name'); ?>
								<?php echo render_input('property_address', 'property_address'); ?>
                                <div id="landlord_wrapper" class="row">
                                    <div class="col-md-4">
                                        <div class="form-group select-placeholder">
                                            <label for="landlordid"
                                                   class="control-label"><?php echo _l('property_customer'); ?></label>
                                            <select id="landlordid" name="landlord_id" data-live-search="true" data-width="100%"
                                                    class="ajax-search"
                                                    data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
												<?php
												$rel_data = get_relation_data('landlord');
												$rel_val = get_relation_values($rel_data, 'landlord');
												echo '<option value="' . $rel_val['id'] . '" selected>' . $rel_val['name'] . '</option>';
												?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group select-placeholder">
                                            <label for="property_type"><?php echo _l('property_type'); ?></label>
                                            <div class="clearfix"></div>
                                            <select id="property_type"
                                                    name="property_type_id"
                                                    data-width="100%"
                                                    class="selectpicker"
                                                    data-none-selected-text="<?php echo _l('dropdown_non_selected_text'); ?>">
												<?php foreach ($property_types as $property_type) { ?>
                                                    <option value="<?php echo $property_type['propertytypeid'] ?>"><?php echo e($property_type['type_name']); ?></option>
												<?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group select-placeholder">
											<?php
											echo render_select('property_managements[]', $staff, ['staffid', ['firstname', 'lastname']], 'property_staffs', $selected, ['multiple' => true, 'data-actions-box' => true], [], '', '', false);
											?>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mtop15">
                                    <div class="col-md-12">
                                        <div class="checkbox checkbox-primary">
                                            <input type="checkbox" name="require_client_confirmation" id="require_client_confirmation" value="1">
                                            <label for="require_client_confirmation">
                                                <?php echo _l('property_require_client_confirmation'); ?>
                                            </label>
                                            <p class="text-muted tw-text-sm tw-mt-1">
                                                <?php echo _l('property_require_client_confirmation_info'); ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <p class="bold"><?php echo _l('project_description'); ?></p>
								<?php $contents = '';
								if (isset($project)) {
    								$contents = $project->description;
								} ?>
								<?php echo render_textarea('description', '', $contents, [], [], '', 'tinymce'); ?>
                                <div class="row attachments">
                                    <div class="col-md-12">
                                        <label for="attachment"
                                               class="control-label"><?php echo _l('property_photos'); ?></label>
                                    </div>
                                    <div class="attachment">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <span class="input-group-btn"><button class="btn btn-default add_more_attachments" type="button"><i class="fa fa-plus"></i></button></span>
                                                    <input type="file"
                                                           accept="image/*"
                                                           extension="<?php echo str_replace('.', '', get_option('allowed_files')); ?>"
                                                           filesize="<?php echo file_upload_max_size(); ?>"
                                                           class="form-control" name="attachments[0]">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="panel-footer text-right">
                        <button type="submit" data-form="#project_form" class="btn btn-primary" autocomplete="off"
                                data-loading-text="<?php echo _l('wait_text'); ?>">
							<?php echo _l('submit'); ?>
                        </button>
                    </div>
                </div>
            </div>
			<?php echo form_close(); ?>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
    $(function () {
        $landlordSelect = $('#landlordid');

        init_ajax_search('landlord', $landlordSelect, {
            rel_id: $landlordSelect.val(),
            type: 'landlord'
        });

        appValidateForm($('#property_form'), {
            name: 'required',
            landlordid: 'required',
            property_type: 'required',
            property_address: 'required'
        });
    });
</script>
</body>

</html>
