<?php

defined('BASEPATH') or exit('No direct script access allowed');
?>
<?php
/**
 * Job Details HTML View - Client Portal
 * Displays job information with signature confirmation
 *
 * @var object $job
 * @var int $job_id
 */

$job_id = $job->jobid;
$CI     = &get_instance();

?>

<div class="mtop15 preview-top-wrapper">
    <!-- Logo Section -->
    <div class="row">
        <div class="col-md-3">
            <div class="mbot30">
                <div class="job-html-logo">
					<?= get_dark_company_logo(); ?>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
    </div>

    <!-- Sticky Header with Title and Actions -->
    <div class="top" data-sticky data-sticky-class="preview-sticky-header">
        <div class="container preview-sticky-container">
            <div class="sm:tw-flex sm:tw-justify-between -tw-mx-4">
                <div class="sm:tw-self-end">
                    <h3 class="bold tw-my-0 job-html-number">
                        <span class="sticky-visible hide tw-mb-2">
                            <?= e($job->job_title); ?>
                        </span>
                    </h3>
                    <span class="job-html-status">
                        <?= format_job_status($job->status, '', TRUE); ?>
                    </span>
                </div>

                <div class="tw-flex tw-items-end tw-space-x-2 tw-mt-3 sm:tw-mt-0">
					<?php
					// Check if property requires client confirmation
					$property_requires_confirmation = isset($job->property['require_client_confirmation']) && $job->property['require_client_confirmation'] == 1;

					// Show "Confirm Satisfied" button only if:
					// 1. Property requires client confirmation
					// 2. Job is not completed or exceeded NTE
					// 3. Job hasn't been confirmed yet
					if ($property_requires_confirmation
					    && $job->status != Jobs_model::STATUS_COMPLETE
					    && $job->status != Jobs_model::STATUS_EXCEED_NTE
					    && empty($job->confirmation_at)
					)
					{
						echo '<button type="button" id="accept_action" class="btn btn-success action-button accept"><i class="fa fa-check"></i> '._l('job_client_confirm_satisfied').'</button>';
					} elseif ($job->confirmation_at)
					{ ?>
                        <span class="job-html-status">
                        <?php
                        echo sprintf('%s %s %s %s', $job->confirmation_firstname, $job->confirmation_lastname, _l('confirmed_at'), $job->confirmation_at) ?>
                    </span>
						<?php
					}
					?>
                </div>
            </div>
        </div>
    </div>

    <div class="clearfix"></div>

    <!-- Main Content Panel -->
    <div class="panel_s tw-mt-6">
        <div class="panel-body">
            <div class="col-md-10 col-md-offset-1">

                <!-- Header Information Section -->
                <div class="row mtop20">
                    <div class="col-md-6 col-sm-6 transaction-html-info-col-left">
                        <h4 class="bold job-html-number">
							<?= e($job->job_title); ?>
                        </h4>
                    </div>

                    <div class="col-sm-6 text-right transaction-html-info-col-right">
                        <span class="tw-font-medium tw-text-neutral-600">
                            <?= _l('job_to'); ?>
                        </span>
                        <address class="job-html-customer-billing-info tw-text-neutral-500 tw-text-normal">
							<?php
							if (isset($job->client))
							{
								echo format_customer_info($job->client, 'statement', 'billing');
							}
							?>
                        </address>
                    </div>
                </div>

                <!-- Job Details Section -->
                <div class="row mtop30">
                    <!-- Left Column: Job Information -->
                    <div class="col-md-6">
                        <table class="table table-striped tw-text-normal">
                            <tbody>
                            <!-- Job Title -->
                            <tr>
                                <td class="tw-font-medium tw-w-1/3"><?= _l('job_title'); ?>:</td>
                                <td class="tw-text-neutral-600"><?= e($job->job_title ?? '—'); ?></td>
                            </tr>

                            <!-- Job Status -->
                            <tr>
                                <td class="tw-font-medium tw-w-1/3"><?= _l('status'); ?>:</td>
                                <td class="tw-text-neutral-600">
									<?= format_job_status($job->status, '', FALSE); ?>
                                </td>
                            </tr>

                            <!-- Date Created -->
                            <tr>
                                <td class="tw-font-medium tw-w-1/3"><?= _l('date_created'); ?>:</td>
                                <td class="tw-text-neutral-600">
									<?php
									$formatted = Datetime::createFromFormat('Y-m-d H:i:s', $job->created_at);
									$formatted = $formatted->format('j F Y, g:ia');
									?>
									<?= $formatted ?>
                                </td>
                            </tr>

                            <!-- Scheduled Visit At -->
                            <tr>
                                <td class="tw-font-medium tw-w-1/3"><?= _l('job_date_visit'); ?>:</td>
                                <td class="tw-text-neutral-600">
									<?php
									if (isset($job->preferred_visit_date)) : ?>
										<?php
										$formatted = Datetime::createFromFormat('Y-m-d H:i:s', $job->preferred_visit_date);
										$formatted = $formatted->format('j F Y, g:ia');
										?>
										<?= $formatted ?>
									<?php
									endif ?>
                                </td>
                            </tr>
                            <!-- Last Updated -->
                            <tr>
                                <td class="tw-font-medium tw-w-1/3"><?= _l('job_updated_at'); ?>:</td>
                                <td class="tw-text-neutral-600">
									<?= e($job->updated_at ? _d($job->updated_at) : _d($job->created_at ?? '')); ?>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- Right Column: Specialists List -->
                    <div class="col-md-6">
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <h4 class="panel-title"><?= _l('job_specialists'); ?></h4>
                            </div>
                            <div class="panel-body">
								<?php
								if ( ! empty($job->specialists) && is_array($job->specialists))
								{
									echo '<ul class="list-group">';
									foreach ($job->specialists as $specialist)
									{
										// Get specialist name from different possible sources
										$specialist_name = $specialist['name'] ?? '';
										if (empty($specialist_name) && ! empty($specialist['staff_id']))
										{
											$specialist_name = get_staff_full_name($specialist['staff_id']);
										}
										$specialist_name = $specialist_name ?: '—';

										echo '<li class="list-group-item">';
										echo '<i class="fa fa-user"></i> '.e($specialist_name);
										echo '</li>';
									}
									echo '</ul>';
								} else
								{
									echo '<p class="text-muted">'._l('no_data').'</p>';
								}
								?>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- Daily Progress Section -->
	<?php
	if ( ! empty($daily_logs))
	{ ?>
        <div class="panel_s tw-mt-6">
            <div class="panel-body">
                <div class="col-md-10 col-md-offset-1">
                    <h4 class="bold tw-mb-4">
                        <i class="fa fa-calendar-check-o"></i>
						<?= _l('customer_daily_progress'); ?>
                    </h4>

                    <!-- Statistics Summary -->
                    <div class="row tw-mb-4">
                        <div class="col-md-4 col-sm-6">
                            <div class="panel panel-default">
                                <div class="panel-body text-center">
                                    <h3 class="tw-my-0 tw-font-semibold"><?= $statistics['total_logs']; ?></h3>
                                    <p class="text-muted tw-mb-0"><?= _l('total_daily_logs'); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-6">
                            <div class="panel panel-default">
                                <div class="panel-body text-center">
                                    <h3 class="tw-my-0 tw-font-semibold"><?= $statistics['total_days']; ?></h3>
                                    <p class="text-muted tw-mb-0"><?= _l('total_days_logged'); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-6">
                            <div class="panel panel-default">
                                <div class="panel-body text-center">
                                    <h3 class="tw-my-0 tw-font-semibold"><?= $statistics['total_photos']; ?></h3>
                                    <p class="text-muted tw-mb-0"><?= _l('total_photos_uploaded'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Filter Buttons -->
                    <div class="row tw-mb-4">
                        <div class="col-md-12">
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-default filter-date active" data-filter="all">
									<?= _l('all_dates'); ?>
                                </button>
                                <button type="button" class="btn btn-default filter-date" data-filter="today">
									<?= _l('today'); ?>
                                </button>
                                <button type="button" class="btn btn-default filter-date" data-filter="last_7_days">
									<?= _l('last_7_days'); ?>
                                </button>
                                <button type="button" class="btn btn-default filter-date" data-filter="this_month">
									<?= _l('this_month'); ?>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Daily Logs Timeline -->
					<?php
					$daily_log_grouped = [];
					foreach ($daily_logs as $daily_log)
					{
						$daily_log_grouped[$daily_log['log_date']][] = $daily_log;
					}
					krsort($daily_log_grouped, SORT_DESC);

					foreach ($daily_log_grouped as $date => $logs) :?>
						<?php
						$collapseName = 'collapse'.$date; ?>
                        <a class="btn btn-primary tw-w-full date-header mbot10" data-date="<?php
						echo $date ?>" data-toggle="collapse" href="#<?php
						echo $collapseName ?>"
                           role="button" aria-expanded="false" aria-controls="<?php
						echo $collapseName ?>">
                            <h4 class="tw-mt-4 tw-mb-3 tw-text-left">
                                <i class="fa fa-calendar"></i>
								<?php
								echo _d($date); ?>
                            </h4>
                        </a>
                        <div class="collapse" id="<?php
						echo $collapseName ?>">
							<?php
							foreach ($logs as $log): ?>
                                <div class="panel panel-default tw-mb-3 daily-log-item" data-date="<?= $log['log_date']; ?>">
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <p class="text-muted">
                                                    <i class="fa fa-clock-o"></i>
													<?= _dt($log['created_at']); ?>
                                                    <span class="pull-right">
                                                <i class="fa fa-user"></i> <?= e($log['staff_full_name']); ?>
                                            </span>
                                                </p>
                                            </div>
                                        </div>

                                        <div class="row mtop10">
                                            <div class="col-md-12">
                                                <div class="well">
													<?= $log['comments']; ?>
                                                </div>
                                            </div>
                                        </div>

										<?php
										if ( ! empty($log['photos']))
										{ ?>
                                            <div class="row mtop10">
                                                <div class="col-md-12">
                                                    <h5><i class="fa fa-camera"></i> <?= _l('photos'); ?>
                                                        (<?= count($log['photos']); ?>)</h5>
                                                    <div class="row">
														<?php
														foreach ($log['photos'] as $photo)
														{
															$download_url = site_url('trade_job_management/download/file/job_daily_log/'.$photo['attachment_key']);
															$image_path   = get_upload_path_by_type('job').$job->jobid.'/daily_logs/'.$photo['file_name'];
															$photo_url    = site_url('trade_job_management/download/preview_image?path='.protected_file_url_by_path($image_path));
															?>
                                                            <div class="col-md-3 col-sm-4 col-xs-6 tw-mb-3">
                                                                <div class="thumbnail">
																	<?php
																	if (is_image($image_path)) : ?>
                                                                        <a href="<?php
																		echo $photo_url ?>"
                                                                           class="lightbox tw-relative"
                                                                           target="_blank"
                                                                           data-lightbox="daily-log-<?= $date ?>">
                                                                            <img src="<?= $photo_url ?>"
                                                                                 class="img-responsive">
                                                                        </a>
                                                                        <div class="caption text-center">
                                                                            <small class="tw-text-wrap tw-break-words"><?= e($photo['file_name']); ?></small>
                                                                            <div class="mtop5">
                                                                                <a class="btn btn-default tw-w-full" href="<?php echo $download_url ?>"><?php echo _l('download') ?></a>
                                                                            </div>
                                                                        </div>
																	<?php
																	else: ?>
                                                                        <a href="<?= $download_url ?>"
                                                                           target="_blank">
                                                                            <div class="text-center" style="padding: 20px;">
                                                                                <i class="<?= get_mime_class($photo['filetype']); ?> fa-4x"></i>
                                                                            </div>
                                                                        </a>
                                                                        <div class="caption text-center">
                                                                            <small class="tw-text-wrap tw-break-words"><?= e($photo['file_name']); ?></small>
                                                                            <div class="mtop5">
                                                                                <a class="btn btn-default tw-w-full" href="<?php echo $download_url ?>"><?php echo _l('download') ?></a>
                                                                            </div>
                                                                        </div>
																	<?php
																	endif ?>

                                                                </div>
                                                            </div>
															<?php
														} ?>
                                                    </div>
                                                </div>
                                            </div>
											<?php
										} ?>
                                    </div>
                                </div>
							<?php
							endforeach; ?>
                        </div>
					<?php
					endforeach; ?>
                </div>
            </div>
        </div>
		<?php
	} ?>

    <!-- Job Confirmation Modal with Signature -->
	<?php
	$this->load->view('jobs/job_confirmation_form', [
		'formData' => form_hidden('job_action', 'signature'),
		'contact'  => $job->client ?? NULL,
	]);
	?>

    <script>
        $(function () {
            new Sticky('[data-sticky]');
            // Handle "Confirm Satisfied" button click
            const confirmButton = $('button.action-button');
            $(confirmButton).on('click', function (e) {
                e.preventDefault();
                console.log('okay')
                $('#identityConfirmationModal').modal('show');
            });

            // Daily Logs Filter functionality
            $('.filter-date').on('click', function () {
                var filter = $(this).data('filter');
                $('.filter-date').removeClass('btn-primary active').addClass('btn-default');
                $(this).removeClass('btn-default').addClass('btn-primary active');

                const today = new Date();
                today.setUTCHours(0, 0, 0);
                const todayString = today.toISOString().split('T')[0]

                $('.date-header').each(function () {
                    var itemDate = new Date($(this).data('date'));
                    var show = false;

                    switch (filter) {
                        case 'all':
                            show = true;
                            break;
                        case 'today':
                            console.log(itemDate, 'todayString' + todayString)
                            show = itemDate.toISOString().split('T')[0] === todayString;
                            break;
                        case 'last_7_days':
                            const endOfToday = new Date();
                            endOfToday.setHours(23, 59, 59, 999);
                            const weekAgo = new Date(today);
                            weekAgo.setDate(weekAgo.getDate() - 7);
                            show = itemDate >= weekAgo && itemDate <= endOfToday;
                            break;
                        case 'this_month':
                            show = itemDate.getMonth() === today.getMonth() &&
                                itemDate.getFullYear() === today.getFullYear();
                            break;
                    }

                    if (show) {
                        $(this).show();
                    } else {
                        $(this).hide();
                    }
                });
            });
        });
    </script>
</div>