<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Property_types_model extends App_Model
{
    public function add($data)
    {
        $data['created_by'] = get_staff_user_id();
        $data['created_at'] = date('Y-m-d H:i:s');
        $data['updated_at'] = date('Y-m-d H:i:s');

        $this->db->insert(db_prefix() . 'tjm_property_types', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New Property Type Created [ID: ' . $insert_id . ']');

            return $insert_id;
        }

        return false;
    }

    public function get($id = '', $active_only = false)
    {
        if (is_numeric($id)) {
            $this->db->where('propertytypeid', $id);

            return $this->db->get(db_prefix() . 'tjm_property_types')->row();
        }

        if ($active_only) {
            $this->db->where('status', 1);
        }

        $this->db->order_by('type_name', 'asc');

        return $this->db->get(db_prefix() . 'tjm_property_types')->result_array();
    }

    public function update($data, $id)
    {
        $data['updated_at'] = date('Y-m-d H:i:s');
        $this->db->where('propertytypeid', $id);

        return $this->db->update(db_prefix() . 'tjm_property_types', $data);
    }

    public function delete($id)
    {
        return $this->db->where('propertytypeid', $id)->delete(db_prefix() . 'tjm_property_types');
    }
}
