<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_142 extends App_module_migration {

	protected $module_name = 'trade_job_management';
	protected int $version = 142;

	public function up()
	{
		zegaware_add_migration_log($this->module_name, $this->version);

		$this->ci->db->query(
			'CREATE TABLE IF NOT EXISTS `'.db_prefix().'tjm_job_nte_logs` (
		      `id` int(11) NOT NULL AUTO_INCREMENT,
		      `job_id` int(11) NOT NULL,
		      `old_nte` decimal(15,2) NOT NULL,
		      `new_nte` decimal(15,2) NOT NULL,
		      `staff_id` int(11) NOT NULL,
	           `created_at` DATETIME NOT NULL,
		      PRIMARY KEY (`id`),
			FOREIGN KEY (`staff_id`) REFERENCES `'.db_prefix().'staff`(`staffid`) ON DELETE CASCADE,
            FOREIGN KEY (`job_id`) REFERENCES `'.db_prefix().'tjm_jobs`(`jobid`) ON DELETE CASCADE
      ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4  COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;',
		);
	}

	public function down()
	{
		zegaware_delete_migration_log($this->module_name, $this->version);

		$this->ci->db->query('DROP TABLE `'.db_prefix().'tjm_job_nte_logs`;');
	}

}
