<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_141 extends App_module_migration {

	protected $module_name = 'trade_job_management';
	protected int $version = 141;

	public function up()
	{
		zegaware_add_migration_log($this->module_name, $this->version);

		$this->ci->db->query(
			'CREATE TABLE IF NOT EXISTS `'.db_prefix().'tjm_job_timers` (
		  `timerid` int NOT NULL AUTO_INCREMENT,
		  `job_id` int NOT NULL,
		  `start_time` int unsigned NOT NULL,
		  `end_time` int unsigned DEFAULT NULL,
		  `staff_id` int NOT NULL,
		  `hourly_rate` decimal(15,2) NOT NULL DEFAULT 0,
		  `cost` decimal(15,2) NOT NULL DEFAULT 0,		  
		  `total` decimal(15,2) NOT NULL DEFAULT 0,
		  `note` mediumtext,
		  PRIMARY KEY (`timerid`),
		  FOREIGN KEY (`staff_id`) REFERENCES `'.db_prefix().'staff`(`staffid`) ON DELETE CASCADE,
		  FOREIGN KEY (`job_id`) REFERENCES `'.db_prefix().'tjm_jobs`(`jobid`) ON DELETE CASCADE
        ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4  COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1',
		);

		if ( ! $this->ci->db->field_exists('nte', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE `'.db_prefix().'tjm_jobs` ADD `nte` decimal(15,2) NOT NULL DEFAULT 0 AFTER `property_id`');
		}
	}

	public function down()
	{
		zegaware_delete_migration_log($this->module_name, $this->version);

		$this->ci->db->query('DROP TABLE `'.db_prefix().'tjm_job_timers`;');

		if ($this->ci->db->field_exists('nte', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE `'.db_prefix().'tjm_jobs` DROP COLUMN `nte`;');
		}
	}

}
