<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_139 extends App_module_migration {

	protected $module_name = 'trade_job_management';
	protected int $version = 139;

	public function up()
	{
		$this->create_landlords_table();
		$this->create_property_types_table();
		$this->create_properties_table();
		$this->create_property_managements_table();
		$this->create_job_types_table();
		$this->create_jobs_table();
		$this->create_job_specialists_table();
		$this->create_job_comments_table();
		$this->create_job_scheduled_logs_table();
		$this->create_job_status_logs_table();
		$this->add_system_table_columns();

		zegaware_add_migration_log($this->module_name, $this->version);
	}

	private function create_landlords_table()
	{
		$db_prefix = db_prefix();
		$this->ci->db->query(
			"
		CREATE TABLE IF NOT EXISTS `{$db_prefix}tjm_landlords` ( 
		`landlordid` int(11) NOT NULL AUTO_INCREMENT,
		`first_name` varchar(50) NOT NULL,
		`last_name` varchar(50) NOT NULL,
		`phone_number` varchar(20) NOT NULL,
		`email` varchar(50) NOT NULL,
		`website` varchar(50),
		`address` varchar(255),
		`city` varchar(100),
		`state` varchar(100),
		`zip_code` varchar(20),
		`country` int(11),
		`client_id` int(11),
		`created_by` int(11) DEFAULT NULL,
		`created_at` datetime DEFAULT CURRENT_TIMESTAMP,
		`updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		PRIMARY KEY (`landlordid`),
		UNIQUE KEY `email` (`email`),
		KEY `idx_created_by` (`created_by`),
		KEY `idx_full_name` (`first_name`, `last_name`),
		CONSTRAINT `fk_landlords_created_by` FOREIGN KEY (`created_by`) REFERENCES `{$db_prefix}staff` (`staffid`) ON DELETE SET NULL,
		CONSTRAINT `fk_landlords_client_id` FOREIGN KEY (`client_id`) REFERENCES `{$db_prefix}clients` (`userid`) ON DELETE SET NULL
      ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4  COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;",
		);
	}

	private function create_property_types_table()
	{
		$db_prefix = db_prefix();
		$this->ci->db->query(
			"
	CREATE TABLE IF NOT EXISTS `{$db_prefix}tjm_property_types` (
    `propertytypeid` int(11) NOT NULL AUTO_INCREMENT,
    `type_name` varchar(255) NOT NULL,
    `status` int NOT NULL DEFAULT 1,
    `created_by` int(11),
    `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
    `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`propertytypeid`),
    KEY `idx_status` (`status`),
    KEY `idx_created_by` (`created_by`),
    CONSTRAINT `fk_property_types_created_by` FOREIGN KEY (`created_by`) REFERENCES `{$db_prefix}staff` (`staffid`) ON DELETE SET NULL 
	) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
		);

		$defined_types = [
			'Apartment'      => 'Apartment',
			'Converted flat' => 'Converted flat',
			'Studio flat'    => 'Studio flat',
			'Cottage'        => 'Cottage',
			'Bungalow'       => 'Bungalow',
			'Detached house' => 'Detached house',
			'Terraced house' => 'Terraced house',
			'End of terrace' => 'End of terrace',
			'Maisonette'     => 'Maisonette',
			'Commercial'     => 'Commercial',
			'Other'          => 'Other',
		];

		foreach ($defined_types as $type => $label)
		{
			$this->ci->db->where('type_name', $type);
			$result = $this->ci
				->db
				->get(db_prefix().'tjm_property_types')
				->row_array();
			if (empty($result))
			{
				$this->ci->db->reset_query();
				$this->ci->db->insert(db_prefix().'tjm_property_types', [
					'type_name'  => $type,
					'status'     => 1,
					'created_by' => get_staff_user_id(),
					'created_at' => date('Y-m-d H:i:s'),
					'updated_at' => date('Y-m-d H:i:s'),
				]);
			}
		}
	}

	private function create_properties_table()
	{
		$db_prefix = db_prefix();

		$this->ci->db->query(
			"
		CREATE TABLE IF NOT EXISTS `{$db_prefix}tjm_properties` (
    `propertyid` int(11) NOT NULL AUTO_INCREMENT,
    `property_name` varchar(255) NOT NULL,
    `property_address` text NOT NULL,
    `landlord_id` int(11) NOT NULL,
    `property_type_id`  int(11) NOT NULL,
    `description` text DEFAULT NULL,
    `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=Active, 0=Inactive',
    `created_by` int(11) DEFAULT NULL,
    `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
    `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`propertyid`),
    KEY `idx_landlord_id` (`landlord_id`),
    KEY `idx_property_type_id` (`property_type_id`),
    KEY `idx_status` (`status`),
    KEY `idx_created_by` (`created_by`),
    CONSTRAINT `fk_properties_landlord` FOREIGN KEY (`landlord_id`) REFERENCES `{$db_prefix}tjm_landlords` (`landlordid`) ON DELETE CASCADE,
    CONSTRAINT `fk_properties_type` FOREIGN KEY (`property_type_id`) REFERENCES `{$db_prefix}tjm_property_types` (`propertytypeid`) ON DELETE CASCADE,
    CONSTRAINT `fk_properties_created_by` FOREIGN KEY (`created_by`) REFERENCES `{$db_prefix}staff` (`staffid`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
",
		);
	}

	private function create_property_managements_table()
	{
		$db_prefix = db_prefix();

		$this->ci->db->query(
			"
		CREATE TABLE IF NOT EXISTS `{$db_prefix}tjm_property_managements` (
	  `pmid` int NOT NULL AUTO_INCREMENT,
	  `property_id` int NOT NULL,
	  `staff_id` int NOT NULL,
	  PRIMARY KEY (`pmid`),
	  KEY `property_id` (`property_id`),
	  KEY `staff_id` (`staff_id`),
    CONSTRAINT `fk_property_managements_property` FOREIGN KEY (`property_id`) REFERENCES `{$db_prefix}tjm_properties` (`propertyid`) ON DELETE CASCADE,
    CONSTRAINT `fk_property_managements_staff` FOREIGN KEY (`staff_id`) REFERENCES `{$db_prefix}staff` (`staffid`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
",
		);
	}

	private function create_job_types_table()
	{
		$db_prefix = db_prefix();
		$this->ci->db->query(
			"
	CREATE TABLE IF NOT EXISTS `{$db_prefix}tjm_job_types` (
    `jobtypeid` int(11) NOT NULL AUTO_INCREMENT,
    `type_name` varchar(255) NOT NULL,
    `color` varchar(20) NOT NULL,
    `status` int NOT NULL DEFAULT 1,
    `created_by` int(11),
    `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
    `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`jobtypeid`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
		);

		$defined_types = [
			[
				'id'    => 1,
				'name'  => _l('job_type_building_and_construction'),
				'color' => '#777',
			],
			[
				'id'    => 2,
				'name'  => _l('job_type_carpentry'),
				'color' => '#03a9f4',
			],
			[
				'id'    => 3,
				'name'  => _l('job_type_electrical'),
				'color' => '#ff6f00',
			],
			[
				'id'    => 4,
				'name'  => _l('job_type_flooring'),
				'color' => '#fc2d42',
			],
			[
				'id'    => 5,
				'name'  => _l('job_type_gardening'),
				'color' => '#777',
			],
			[
				'id'    => 6,
				'name'  => _l('job_type_handyman_services'),
				'color' => '#03a9f4',
			],
			[
				'id'    => 7,
				'name'  => _l('job_type_hvac_services'),
				'color' => '#ff6f00',
			],
			[
				'id'    => 8,
				'name'  => _l('job_type_locksmith_services'),
				'color' => '#fc2d42',
			],
			[
				'id'    => 9,
				'name'  => _l('job_type_painting_and_decorating'),
				'color' => '#777',
			],
			[
				'id'    => 10,
				'name'  => _l('job_type_plumbing'),
				'color' => '#03a9f4',
			],
			[
				'id'    => 11,
				'name'  => _l('job_type_roofing'),
				'color' => '#ff6f00',
			],
			[
				'id'    => 12,
				'name'  => _l('job_type_tiling'),
				'color' => '#fc2d42',
			],
			[
				'id'    => 13,
				'name'  => _l('job_type_window_fitting'),
				'color' => '#fc2d42',
			],
		];

		foreach ($defined_types as $job_type)
		{
			$this->ci->db->where('jobtypeid', $job_type['id']);
			$result = $this->ci
				->db
				->get(db_prefix().'tjm_job_types')
				->row_array();
			if (empty($result))
			{
				$this->ci->db->reset_query();
				$this->ci->db->insert(db_prefix().'tjm_job_types', [
					'jobtypeid'  => $job_type['id'],
					'type_name'  => $job_type['name'],
					'color'      => $job_type['color'],
					'status'     => 1,
					'created_by' => get_staff_user_id(),
					'created_at' => date('Y-m-d H:i:s'),
					'updated_at' => date('Y-m-d H:i:s'),
				]);
			}
		}
	}

	private function create_jobs_table()
	{
		$db_prefix = db_prefix();
		$this->ci->db->query(
			"
		CREATE TABLE IF NOT EXISTS `{$db_prefix}tjm_jobs` (
    `jobid` int(11) NOT NULL AUTO_INCREMENT,
    `job_title` varchar(255) NOT NULL,
    `job_type_id` int(11) NOT NULL,
    `priority` int NOT NULL DEFAULT 1,
    `property_id` int(11) NOT NULL,
    `preferred_visit_date` datetime,
    `contact_name` varchar(50) NOT NULL,
    `contact_phone` varchar(20) NOT NULL,
    `job_description` text DEFAULT NULL,
    `status` int NOT NULL DEFAULT 1,
    `billed` boolean NOT NULL DEFAULT 0,
    `invoice_id` int,
    `created_by` int(11) DEFAULT NULL,
    `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
    `completed_at` datetime,
    `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`jobid`),
    KEY `idx_property_id` (`property_id`),
    KEY `idx_job_type_id` (`job_type_id`),
    KEY `idx_priority` (`priority`),
    KEY `idx_status` (`status`),
    KEY `idx_preferred_visit_date` (`preferred_visit_date`),
    KEY `idx_created_by` (`created_by`),
    CONSTRAINT `fk_jobs_property` FOREIGN KEY (`property_id`) REFERENCES `{$db_prefix}tjm_properties` (`propertyid`) ON DELETE CASCADE,
    CONSTRAINT `fk_jobs_type` FOREIGN KEY (`job_type_id`) REFERENCES `{$db_prefix}tjm_job_types` (`jobtypeid`) ON DELETE CASCADE,
    CONSTRAINT `fk_jobs_created_by` FOREIGN KEY (`created_by`) REFERENCES `{$db_prefix}staff` (`staffid`) ON DELETE SET NULL
		) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
		);
	}

	private function create_job_specialists_table()
	{
		$db_prefix = db_prefix();

		$this->ci->db->query(
			"
		CREATE TABLE IF NOT EXISTS `{$db_prefix}tjm_job_specialists` (
	  `jsid` int NOT NULL AUTO_INCREMENT,
	  `job_id` int NOT NULL,
	  `staff_id` int NOT NULL,
	  PRIMARY KEY (`jsid`),
	  KEY `job_id` (`job_id`),
	  KEY `staff_id` (`staff_id`),
    CONSTRAINT `fk_tjm_job_specialists_job` FOREIGN KEY (`job_id`) REFERENCES `{$db_prefix}tjm_jobs` (`jobid`) ON DELETE CASCADE,
    CONSTRAINT `fk_tjm_job_specialists_staff` FOREIGN KEY (`staff_id`) REFERENCES `{$db_prefix}staff` (`staffid`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
",
		);
	}

	private function create_job_comments_table()
	{
		$db_prefix = db_prefix();

		$this->ci->db->query(
			"
        CREATE TABLE IF NOT EXISTS `{$db_prefix}tjm_job_comments` (
            `jcid` int NOT NULL AUTO_INCREMENT,
            `content` longtext COLLATE utf8mb4_unicode_ci,
            `job_id` int NOT NULL,
            `staff_id` int NOT NULL,
            `file_id` int NOT NULL DEFAULT '0',
            `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
            `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (`jcid`),
            KEY `file_id` (`file_id`),
            KEY `job_id` (`job_id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
		);
	}

	private function create_job_scheduled_logs_table()
	{
		$this->ci->db->query(
			'CREATE TABLE IF NOT EXISTS `'
			.db_prefix()
			.'tjm_job_scheduled_logs` (
	      `id` int(11) NOT NULL AUTO_INCREMENT,
	      `job_id` int(11) NOT NULL,
	      `old_scheduled_time` DATETIME NULL,
	      `new_scheduled_time` DATETIME NOT NULL,
	      `staff_id` int(11) NOT NULL,
	      `created_at` DATETIME NOT NULL,
	      PRIMARY KEY (`id`),
    FOREIGN KEY (`staff_id`) REFERENCES `'
			.db_prefix()
			.'staff`(`staffid`) ON DELETE CASCADE,
    FOREIGN KEY (`job_id`) REFERENCES `'
			.db_prefix()
			.'tjm_jobs`(`jobid`) ON DELETE CASCADE
      ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4  COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;',
		);
	}

	private function create_job_status_logs_table()
	{
		$this->ci->db->query(
			'CREATE TABLE IF NOT EXISTS `'
			.db_prefix()
			.'tjm_job_status_logs` (
		      `id` int(11) NOT NULL AUTO_INCREMENT,
		      `job_id` int(11) NOT NULL,
		      `old_status` int(1) NOT NULL,
		      `new_status` int(1) NOT NULL,
		      `staff_id` int(11) NOT NULL,
	            `created_at` DATETIME NOT NULL,
		      PRIMARY KEY (`id`),
			FOREIGN KEY (`staff_id`) REFERENCES `'
			.db_prefix()
			.'staff`(`staffid`) ON DELETE CASCADE,
            FOREIGN KEY (`job_id`) REFERENCES `'
			.db_prefix()
			.'tjm_jobs`(`jobid`) ON DELETE CASCADE
      ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4  COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;',
		);
	}

	private function add_system_table_columns()
	{
		if ( ! $this->ci->db->field_exists('job_comment_id', db_prefix().'files'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'files ADD COLUMN `job_comment_id` INT');
		}
	}

	public function down()
	{
		$db_prefix = db_prefix();
		$this->ci->db->query("DROP TABLE IF EXISTS `{$db_prefix}tjm_property_managements`");
		$this->ci->db->query("DROP TABLE IF EXISTS `{$db_prefix}tjm_job_scheduled_logs`");
		$this->ci->db->query("DROP TABLE IF EXISTS `{$db_prefix}tjm_job_status_logs`");
		$this->ci->db->query("DROP TABLE IF EXISTS `{$db_prefix}tjm_job_comments`");
		$this->ci->db->query("DROP TABLE IF EXISTS `{$db_prefix}tjm_job_specialists`");
		$this->ci->db->query("DROP TABLE IF EXISTS `{$db_prefix}tjm_jobs`");
		$this->ci->db->query("DROP TABLE IF EXISTS `{$db_prefix}tjm_job_types`");
		$this->ci->db->query("DROP TABLE IF EXISTS `{$db_prefix}tjm_properties`");
		$this->ci->db->query("DROP TABLE IF EXISTS `{$db_prefix}tjm_property_types`");
		$this->ci->db->query("DROP TABLE IF EXISTS `{$db_prefix}tjm_landlords`");

		if ($this->ci->db->field_exists('job_comment_id', db_prefix().'files'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'files DROP COLUMN `job_comment_id`');
		}

		zegaware_delete_migration_log($this->module_name, $this->version);
	}


	public function add_migration_log()
	{
		$migration_exists = $this->ci
			->db
			->where('version', $this->version)
			->where('module', $this->module_name)
			->get(db_prefix() . 'module_migrations')
			->row();

		if (!$migration_exists) {
			// Record the applied migration
			$this->ci->db->insert(db_prefix() . 'module_migrations', [
				'module' => $this->module_name,
				'version' => $this->version,
				'applied_at' => date('Y-m-d H:i:s'),
			]);

			return $this->ci->db->affected_rows() > 0;
		}

		return false;
	}

	public function delete_migration_log()
	{
		$migration_exists = $this->ci
			->db
			->where('version', $this->version)
			->where('module', $this->module_name)
			->get(db_prefix() . 'module_migrations')
			->row();

		if ($migration_exists) {
			// Record the applied migration

			$this->ci->db->where('module', $this->module_name);
			$this->ci->db->where('version', $this->version);
			$this->ci->db->delete(db_prefix() . 'module_migrations');

			return $this->ci->db->affected_rows() > 0;
		}

		return false;
	}
}
