<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Property_types extends AdminController
{
    protected const BASE_PATH = '/property_types';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('property_types_model');
    }

    /* List all clients */

    public function index()
    {
        if (staff_cant('view', 'projects')) {
            if (!have_assigned_customers() && staff_cant('create', 'projects')) {
                access_denied('projects');
            }
        }

        $data['title'] = _l('property_type');
        $data['property_types'] = $this->property_types_model->get();

        $this->load->view(static::BASE_PATH . '/index', $data);
    }

    public function save()
    {
        if (!$this->input->is_ajax_request()) {
            redirect(admin_url());
            exit();
        }
        $values = $this->input->post();
        $name = trim($values['type_name']);
        $name_lowercase = strtolower($name);

        if (empty($name)) {
            echo
                json_encode([
                    'success' => false,
                    'message' => _l('property_type_name_required'),
                ])
            ;
            die();
        }

        $property_types = $this->property_types_model->get();
        foreach ($property_types as $property_type) {
            $current_name = strtolower(trim($property_type['type_name']));
            if ($name_lowercase === $current_name) {
                echo
                    json_encode([
                        'success' => false,
                        'message' => _l('property_type_name_already_exists'),
                    ])
                ;
                die();
            }
        }

        $this->property_types_model->add($values);

        echo
            json_encode([
                'success' => true,
                'message' => _l('property_type_added_successfully'),
            ])
        ;
        die();
    }

    public function update(): void
    {
        if (!$this->input->is_ajax_request()) {
            redirect(admin_url());
            exit();
        }
        $values = $this->input->post();
        $id = trim($values['id']);
        if (empty($id) || !pme_get_property_type_by_id($id)) {
            echo
                json_encode([
                    'success' => false,
                    'message' => _l('property_type_not_found'),
                ])
            ;
            die();
        }

        $name = trim($values['type_name']);
        if (pme_get_property_type_by_name($name)) {
            echo
                json_encode([
                    'success' => false,
                    'message' => _l('property_type_name_already_exists'),
                ])
            ;
            die();
        }

        $current_property_type = pme_get_property_type_by_id($id);
        $old_name = $current_property_type['type_name'];

        $updated_data = [
            'id' => $id,
            'name' => $name,
            'bg_color' => $values['bg_color'] ?? '#000000',
            'text_color' => $values['text_color'] ?? '#FFFFFF',
            'sort_order' => $values['sort_order'] ?? 1,
            'add_exist' => ($values['add_exist'] ?? 'false') === 'true',
            'add_future' => ($values['add_future'] ?? 'false') === 'true',
        ];

        if (empty(array_diff($updated_data, $current_property_type))) {
            echo
                json_encode([
                    'success' => true,
                    'message' => _l('property_type_updated_successfully'),
                ])
            ;
            die();
        } else {
            $property_types = pme_get_property_types();
            $property_types = array_map(function ($item) use ($id, $updated_data) {
                return $item['id'] === $id ? $updated_data : $item;
            }, $property_types);

            pme_update_property_types($property_types);
            pme_update_property_type_to_exist_project($old_name, $updated_data);

            if ($updated_data['add_exist']) {
                pme_add_property_type_to_exist_project($updated_data);
            }
            echo
                json_encode([
                    'success' => true,
                    'message' => _l('property_type_updated_successfully'),
                ])
            ;
            die();
        }
    }

    public function delete()
    {
        if (!$this->input->post()) {
            access_denied('method not allowed');
            exit();
        }

        $type_id = trim($this->input->post('property_type_id'));

        $property_type = pme_get_property_type_by_id($type_id);
        if (!$property_type) {
            echo
                json_encode([
                    'success' => false,
                    'message' => _l('can_not_delete_this_property_type'),
                ])
            ;
            exit();
        }

        pme_delete_property_type_by_id($type_id);
        pme_delete_property_type_from_all_project($property_type['type_name']);

        echo
            json_encode([
                'success' => true,
                'message' => _l('deleted_property_type'),
            ])
        ;
        exit();
    }
}
