<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Clients extends AdminController
{
    protected const BASE_PATH = '/clients';
    protected const MODULE_NAME = 'project_management_enhancements';

    public function __construct()
    {
        parent::__construct();

        $this->load->model('api_clients_model');
    }

    /* List all clients */
    public function index()
    {
        if (!is_admin()) {
            access_denied('clients');
        }

        $data['title'] = _l('TJM API Clients');

        $data['table'] = App_table::find('landlords');

        $this->load->view(static::BASE_PATH . '/index', $data);
    }

    public function table()
    {
        App_table::find('api_clients')->output();
    }

    public function create()
    {
        if (!is_admin()) {
            access_denied('clients');
        }

        $data = $this->input->post();

        if (empty($data) || !isset($data['client_name'])) {
            echo
                json_encode([
                    'success' => true,
                ])
            ;
        }
        $data = [
            'client_name' => $data['client_name'],
            'client_ip' => $data['client_ip'] ?? '*',
        ];

        $result = $this->api_clients_model->add($data);

        echo
            json_encode([
                'success' => (bool) $result,
                'message' => $result ? _l('tjm_api_client_added_successfully') : _l('tjm_api_client_failed_to_add'),
            ])
        ;
    }

    public function delete($id = '')
    {
        if (!is_admin() || empty($id)) {
            access_denied('clients');
        }

        $result = $this->api_clients_model->delete($id);

        if ($result) {
            set_alert('success', _l('tjm_api_client_deleted_successfully'));
        } else {
            set_alert('error', _l('tjm_api_client_failed_to_delete'));
        }

        redirect(admin_url(TRADE_JOB_MANAGEMENT_MODULE_NAME . '/' . static::BASE_PATH));
        exit();
    }
}
