<?php


// ----------------------
// ADMIN SETTINGS & DASHBOARD
// ----------------------
// Module Information
$lang['appointly_module_name'] = 'Appointly';
$lang['appointly_current_version'] = 'Aktuelle Modulversion: ';
$lang['appointly_settings_label_pointer'] = '<strong>Einrichtung -> Einstellungen -> Termine</strong>';
$lang['appointly_integrations'] = 'Integrationen';
$lang['general_settings'] = 'Allgemeine Einstellungen';
$lang['new_appointment_notification'] = 'Neuer Termin benötigt Genehmigung';
$lang['appointment_notification'] = 'Sie haben einen neuen Termin zugewiesen bekommen';
$lang['external_appointment_provider_notification'] = 'Sie wurden als Anbieter für einen neuen externen Termin zugewiesen';
$lang['appointment_datetime_changed'] = 'Termin Datum/Zeit wurde geändert';
$lang['appointment_attendees_changed'] = 'Termin Teilnehmer wurden aktualisiert';
$lang['appointment_details_changed'] = 'Termin Details wurden aktualisiert';
$lang['appointment_status_changed'] = 'Termin Status wurde geändert';
$lang['appointment_attendee_removed'] = 'Ein Teilnehmer wurde vom Termin entfernt';

// Admin Settings
$lang['appointments_approve_automatically_label'] = 'Automatisch eingereichte Termine aus externen Webformularen genehmigen';
$lang['appointments_reminder_time_value'] = 'Wert hinzufügen, um eine E-Mail-Benachrichtigung vor Ihrem Termin zu erhalten (Standard 30 Min. vorher)';
$lang['appointly_default_table_filter_label'] = 'Standard-Termintabellenfilter';
$lang['appointment_your_settings'] = 'Ihre Termineinstellungen';
$lang['appointments_buffer_hours_label'] = 'Datumsauswahl vergangener Daten deaktivieren';

// Dashboard & Analytics
$lang['appointly_show_summary_in_appointments_dashboard'] = 'Terminübersicht im Termin-Dashboard anzeigen';
$lang['appointments_summary'] = 'Terminübersicht';
$lang['appointment_appointments_dashboard'] = 'Dashboard';
$lang['appointment_want_to_go_back'] = 'Termine';
$lang['appointly_analytics_dashboard'] = 'Appointly Analyse-Dashboard';
$lang['appointment_history_label'] = 'Vergangene Termine';
$lang['appointment_history_label_menu_label'] = 'Terminhistorie';
$lang['appointment_services_menu_label'] = 'Dienste';
$lang['appointment_analytics_and_reports_menu_label'] = 'Analysen & Berichte';

// Invoice Conversion
$lang['appointment_convert_to_invoice'] = 'In Rechnung umwandeln';
$lang['appointment_converted_to_invoice'] = 'Termin erfolgreich in Rechnung umgewandelt';
$lang['appointment_convert_to_invoice_success'] = 'Termin erfolgreich in Rechnung #%s umgewandelt';
$lang['appointment_convert_to_invoice_failed'] = 'Fehler beim Umwandeln des Termins in Rechnung';
$lang['appointment_are_you_sure_convert_to_invoice'] = 'Sind Sie sicher, dass Sie diesen Termin in eine Rechnung umwandeln möchten?';
$lang['appointment_view_invoice'] = 'Rechnung #%s anzeigen';
$lang['appointment_convert_to_invoice_tooltip'] = 'Die Rechnungserstellung ist nur für Termine mit tatsächlichen Kunden verfügbar. Für Leads oder externe Kontakte müssen Sie diese zuerst in Kunden umwandeln.';
$lang['appointment_external_contact_converted_to_client'] = 'Externer Kontakt erfolgreich in Kunden umgewandelt';
$lang['appointment_external_contact_convert_to_client_error'] = 'Fehler beim Umwandeln des externen Kontakts in Kunden';
$lang['appointment_convert_to_customer_first'] = 'Zuerst in Kunden umwandeln';
$lang['appointment_convert_lead_to_customer'] = 'Lead in Kunden umwandeln';
$lang['appointment_convert_external_to_customer'] = 'In Kunden umwandeln';
$lang['appointment_convert_only'] = 'Nur umwandeln';
$lang['appointment_convert_and_view'] = 'Umwandeln und anzeigen';
$lang['appointment_convert_to_invoice_only_contacts_allowed'] = 'Nur interne Termine mit Kontakten können in Rechnungen umgewandelt werden';

// Lead Conversion
$lang['appointments_convert_to_lead'] = 'Termin in Lead umwandeln';
$lang['appointments_convert_to_lead_label'] = 'In Lead umwandeln';
$lang['appointments_create_task_tooltip'] = 'In Aufgabe umwandeln';
$lang['appointments_convert_to_lead_tooltip'] = 'In Lead umwandeln';
$lang['appointments_select_option'] = 'Option auswählen';
$lang['appointments_contact_name_task'] = 'Termin: Kontaktname';

// Reports Dashboard
$lang['appointly_reports_dashboard'] = 'Appointly Berichte-Dashboard';
$lang['appointly_date_range'] = 'Datumsbereich';
$lang['appointly_today'] = 'Heute';
$lang['appointly_this_week'] = 'Diese Woche';
$lang['appointly_this_month'] = 'Diesen Monat';
$lang['appointly_this_year'] = 'Dieses Jahr';
$lang['appointly_last_month'] = 'Letzten Monat';
$lang['appointly_last_year'] = 'Letztes Jahr';
$lang['appointly_last_30_days'] = 'Letzte 30 Tage';
$lang['appointly_custom_range'] = 'Benutzerdefinierter Bereich';
$lang['appointly_period_from'] = 'Zeitraum von';
$lang['appointly_period_to'] = 'Zeitraum bis';
$lang['appointly_date_range_required'] = 'Bitte wählen Sie einen gültigen Datumsbereich';
$lang['appointly_apply'] = 'Anwenden';
$lang['appointly_total_appointments'] = 'Gesamtzahl der Termine';
$lang['appointly_completed_appointments'] = 'Abgeschlossene Termine';
$lang['appointly_cancelled_appointments'] = 'Stornierte Termine';
$lang['appointly_monthly_stats'] = 'Monatliche Statistiken';
$lang['appointly_popular_services'] = 'Beliebte Dienste';
$lang['appointly_staff_performance'] = 'Mitarbeiterleistung';
$lang['appointly_staff_member'] = 'Mitarbeiter';
$lang['appointly_appointment_total_appointments'] = 'Gesamtzahl der Termine';
$lang['appointly_appointment_completed_appointments'] = 'Abgeschlossene Termine';
$lang['appointly_appointment_cancelled_appointments'] = 'Stornierte Termine';
$lang['appointly_appointment_completion_rate'] = 'Abschlussrate';
$lang['appointly_filter'] = 'Filter';
$lang['appointly_no_staff_performance_data'] = 'Keine Mitarbeiterleistungsdaten für den ausgewählten Zeitraum verfügbar';
$lang['appointly_report'] = 'Bericht';
$lang['appointly_reports_updated_for_period'] = 'Berichte aktualisiert für den Zeitraum: %s bis %s';
$lang['appointly_no_data_for_period'] = 'Keine Daten für den ausgewählten Zeitraum verfügbar';
$lang['appointly_invalid_date_format'] = 'Ungültiges Datumsformat. Bitte verwenden Sie den Datumswähler, um Daten auszuwählen';
$lang['appointly_loading_data'] = 'Daten werden geladen...';
$lang['appointly_error_refreshing_stats'] = 'Fehler beim Aktualisieren der Statistiken. Bitte versuchen Sie es erneut.';
$lang['appointly_no_data_found'] = 'Keine Daten gefunden';
$lang['appointly_staff_respect_availability'] = 'Personal respektiert Verfügbarkeit Buchungskonflikte';
$lang['appointly_staff_respect_availability_tooltip'] = 'Wenn aktiviert, kann Personal keine Termine während ihrer belegten Stunden oder bestehenden Konflikte buchen';

// Analytics Dashboard
$lang['total_appointments'] = 'Gesamtzahl der Termine';
$lang['completed_appointments'] = 'Abgeschlossene Termine';
$lang['cancelled_appointments'] = 'Stornierte Termine';
$lang['monthly_statistics'] = 'Monatliche Statistiken';
$lang['popular_services'] = 'Beliebte Dienste';
$lang['staff_performance'] = 'Mitarbeiterleistung';
$lang['staff_member'] = 'Mitarbeiter';
$lang['completion_rate'] = 'Abschlussrate';
$lang['from_date'] = 'Von Datum';
$lang['to_date'] = 'Bis Datum';
$lang['appointment_statistics_total'] = 'Gesamtzahl der Termine';
$lang['appointment_statistics_completed'] = 'Abgeschlossene Termine';
$lang['appointment_statistics_cancelled'] = 'Stornierte Termine';

$lang['appointment_services_to_show_in_booking_form'] = 'Wählen Sie aus, welche Dienste im öffentlichen Buchungsformular angezeigt werden sollen';
$lang['appointment_services_select_all_to_show_all'] = 'Leer lassen, um alle aktiven Dienste anzuzeigen';
$lang['appointment_select_attendees'] = 'Teilnehmer';
$lang['appointment_select_attendees_help'] = 'Wählen Sie zusätzliche Mitarbeiter aus, die an diesem Termin teilnehmen werden';
$lang['appointment_related'] = 'Verwandt';

// Service Availability Settings
$lang['services_availability_updated_successfully'] = 'Dienstverfügbarkeit erfolgreich aktualisiert';
$lang['services_availability_update_failed'] = 'Fehler beim Aktualisieren der Dienstverfügbarkeit';
$lang['appointment_error_loading_providers'] = 'Fehler beim Laden der Anbieter';
$lang['appointment_select_service_warning'] = 'Bitte wählen Sie einen Dienst aus';
$lang['appointment_select_provider_warning'] = 'Bitte wählen Sie einen Anbieter aus';
$lang['appointment_select_date_time_warning'] = 'Bitte wählen Sie ein Datum und eine Uhrzeit aus';
$lang['appointment_loading_providers'] = 'Anbieter werden geladen...';
$lang['appointment_select_date'] = 'Datum auswählen';
$lang['appointment_your_details'] = 'Ihre Details';
$lang['appointment_continue'] = 'Weiter';
$lang['appointment_back'] = 'Zurück';
$lang['appointment_summary'] = 'Terminübersicht';
$lang['appointment_view_details'] = 'Details anzeigen';
$lang['appointment_select'] = 'Auswählen';
$lang['error_loading_data'] = 'Fehler beim Laden der Daten';
$lang['appointment_booking_failed'] = 'Terminbuchung fehlgeschlagen. Bitte versuchen Sie es erneut.';
$lang['appointment_successfully_scheduled'] = 'Termin erfolgreich geplant';
$lang['appointment_successfully_scheduled_message'] = 'Vielen Dank! Ihr Termin wurde erfolgreich geplant.';
$lang['appointment_successfully_scheduled_button'] = 'Super!';
$lang['appointment_schedule_another'] = 'Einen weiteren planen';
$lang['appointment_not_specified'] = 'Nicht angegeben';
$lang['appointment_booking_confirmed'] = 'Vielen Dank! Ihr Termin wurde erfolgreich geplant.';
$lang['appointment_pending_approval_message'] = 'Ihr Termin wartet auf die Genehmigung des Personals. Sie werden benachrichtigt, sobald er bestätigt ist.';
$lang['appointment_whats_next'] = 'Was kommt als Nächstes?';
$lang['appointment_staff_review'] = 'Unser Personal prüft Ihre Anfrage. Bitte warten Sie auf die Bestätigung.';
$lang['appointment_email_confirmation'] = 'Sie erhalten in Kürze eine E-Mail-Bestätigung mit allen Termindetails.';
$lang['appointment_prepare'] = 'Bitte bereiten Sie alle erforderlichen Dokumente oder Details vor Ihrem Termin vor.';
$lang['appointment_files'] = 'Dateien';
$lang['appointment_externally_booked_info'] = 'Dieser Termin wurde über das externe Buchungsformular gebucht';
$lang['appointment_booked_from_external_booking_form'] = 'Gebucht von';
$lang['appointment_subject_required'] = 'Betreff ist für den Termin erforderlich';
$lang['appointment_attendees_required'] = 'Mindestens ein Mitarbeiter muss am Termin teilnehmen';
$lang['appointment_name_required'] = 'Name ist für externe Termine erforderlich';
$lang['appointment_email_required'] = 'E-Mail ist für externe Termine erforderlich';
$lang['appointment_email_invalid'] = 'Bitte geben Sie eine gültige E-Mail-Adresse an';
$lang['appointment_contact_required'] = 'Bitte wählen Sie einen Kontakt für den internen Termin aus';
$lang['appointment_invalid_type'] = 'Ungültiger ausgewählter Termintyp';
$lang['appointment_type_required'] = 'Bitte wählen Sie einen Termintyp aus';
$lang['appointment_invalid_data'] = 'Ungültige Termindaten angegeben';
$lang['appointment_could_not_be_created'] = 'Der Termin konnte nicht erstellt werden. Bitte versuchen Sie es erneut.';
$lang['appointment_unavailable_slots'] = 'Rote Slots sind aufgrund bestehender Termine nicht verfügbar';
$lang['appointment_book_now_description'] = 'Buchen Sie jetzt Ihren Termin und erhalten Sie den besten Service von unserem Team';
$lang['appointment_book_now_button_description'] = 'Buchen Sie jetzt Ihren Termin und erhalten Sie den besten Service von unserem Team';
$lang['appointment_feature_coming_soon'] = 'Diese Funktion wird in den kommenden Updates verfügbar sein. Bleiben Sie dran!';
$lang['appointment_description_updated'] = 'Terminbeschreibung erfolgreich aktualisiert';
$lang['appointment_notes_updated'] = 'Terminnotizen erfolgreich aktualisiert';
$lang['appointment_notes_update_failed'] = 'Fehler beim Aktualisieren der Terminnotizen';
$lang['appointment_update_failed'] = 'Fehler beim Aktualisieren des Termins';
$lang['appointment_description_edit_info'] = 'Klicken Sie, um die Beschreibung zu bearbeiten. Änderungen werden automatisch gespeichert, wenn Sie die Bearbeitung beenden.';
$lang['appointment_viewing_notes'] = 'Notizen für Termin anzeigen';
$lang['appointment_edit_history_notes'] = 'Notizen bearbeiten';
$lang['appointment_email_missing'] = 'E-Mail-Adresse fehlt oder ist für diesen Termin ungültig';
$lang['appointment_no_name_provided'] = 'Kein Name angegeben';
$lang['appointment_no_phone_provided'] = 'Keine Telefonnummer angegeben';
$lang['appointment_open_link'] = 'Link öffnen';
$lang['appointment_menu_form_link'] = 'Buchungsformular';
$lang['external_form_heading'] = 'Überschrift des Buchungsformulars';
$lang['external_form_description'] = 'Beschreibung des Buchungsformulars';
$lang['appointment_date_location'] = 'Sitzungsdetails';
$lang['appointment_schedule_description'] = 'Füllen Sie das untenstehende Formular aus, um Ihre Sitzung mit unserem Team zu vereinbaren';
$lang['appointment_preferred_date_time'] = 'Bevorzugtes Datum & Uhrzeit';
$lang['appointment_select_date_time'] = 'Auswählen...';
$lang['appointment_terms_description'] = 'Mit dem Fortfahren bestätigen Sie Ihre Annahme unserer';
$lang['appointment_terms_link'] = 'Allgemeinen Geschäftsbedingungen';
$lang['appointment_accept_terms'] = 'Ich bestätige und stimme den Nutzungsbedingungen zu*';
$lang['appointly_recaptcha_enabled'] = 'Recaptcha aktivieren';
$lang['appointment_no_location_provided'] = 'Kein Standort angegeben, um Google Maps anzuzeigen';
$lang['appointment_imported_from_calendar'] = 'Importiert aus %s';
$lang['appointment_imported_cant_edit_notice'] = 'Dieser Termin wurde aus einem externen Kalender importiert und kann nicht bearbeitet werden.';
$lang['appointment_are_you_sure'] = 'Sind Sie sicher, dass Sie diesen Termin löschen möchten?';
$lang['would_you_like_to_create_new_appointment_for_lead'] = 'Möchten Sie einen neuen Termin für diesen Lead erstellen?';
$lang['would_you_like_to_create_new_appointment_for_client'] = 'Möchten Sie einen neuen Termin für diesen Kunden erstellen?';
$lang['would_you_like_to_create_new_appointment'] = 'Möchten Sie einen neuen Termin erstellen?';
$lang['no_appointments_found'] = 'Keine Termine gefunden';

// ----------------------
// EXTERNAL BOOKING FORM
// ----------------------
$lang['appointment_available_days'] = 'Verfügbar';
$lang['appointment_busy_days'] = 'Belegt (hat Termine)';
$lang['appointment_provider_unavailable'] = 'Anbieter nicht verfügbar';
$lang['appointment_blocked_days'] = 'Feiertag/Gesperrter Termin des Unternehmens';
$lang['appointment_date_required'] = 'Bitte wählen Sie zuerst ein Datum aus';
$lang['appointment_select_time'] = 'Uhrzeit auswählen';
$lang['appointment_book_now'] = 'Jetzt buchen';
$lang['appointment_submitting'] = 'Termin wird gebucht...';

// New appointment filter options
$lang['appointment_today'] = 'Heutige Termine';
$lang['appointment_tomorrow'] = 'Morgige Termine';
$lang['appointment_this_week'] = 'Termine dieser Woche';
$lang['appointment_next_week'] = 'Termine nächste Woche';
$lang['appointment_this_month'] = 'Termine diesen Monat';
$lang['appointment_my_appointments'] = 'Meine Termine';
$lang['appointment_assigned_to_me'] = 'Mir zugewiesen';


// ----------------------
// GENERAL/COMMON TERMS
// ----------------------
$lang['appointment_yes'] = 'Ja';
$lang['appointment_no'] = 'Nein';
$lang['appointment_appointments'] = 'Termine';
$lang['appointment_label'] = 'Termin';
$lang['wait_text'] = 'Bitte warten...';
$lang['loading_text'] = 'Wird geladen, bitte warten...';
$lang['appointment_loading'] = 'Wird geladen...';
$lang['unknown_error'] = 'Unbekannter Fehler';
$lang['request_failed'] = 'Anfrage fehlgeschlagen';
$lang['error_processing_response'] = 'Fehler beim Verarbeiten der Antwort';
$lang['invalid_appointment_id'] = 'Ungültige Termin-ID';
$lang['appointment_select_option'] = 'Option auswählen';
$lang['appointly_note'] = 'Hinweis';
$lang['appointment_optional'] = '<small> (optional) </small>';
$lang['required_field_missing'] = 'Das Feld ist erforderlich';
$lang['appointly_required_field'] = 'Erforderliches Feld';
$lang['settings_updated'] = 'Einstellungen erfolgreich aktualisiert';
$lang['appointment_settings_update_failed'] = 'Einstellungen aktualisieren fehlgeschlagen';

// Button text and status terms
$lang['appointment_save'] = 'Speichern';
$lang['appointment_cancel_btn'] = 'Abbrechen';
$lang['appointment_delete_btn'] = 'Löschen';
$lang['appointment_unknown'] = 'Unbekannt';
$lang['appointment_all_day'] = 'Ganztägig';
$lang['appointment_to_be_confirmed'] = 'Zu bestätigen';
$lang['appointment_timezone'] = 'Zeitzone';
$lang['appointment_updating'] = 'Aktualisieren...';
$lang['appointment_requested_at'] = 'Angefragt am';

// Error messages
$lang['appointment_error_loading_details'] = 'Fehler beim Laden der Termin Details';
$lang['appointment_error_loading_contacts'] = 'Fehler beim Laden der Kontakte';
$lang['appointment_unknown_error'] = 'Unbekannter Fehler';
$lang['appointment_please_select_time_slot'] = 'Bitte wählen Sie einen verfügbaren Zeitslot';
$lang['appointment_error_generating_html'] = 'Fehler beim Generieren von HTML';
$lang['appointment_error_loading_blocked_days'] = 'Fehler beim Laden der gesperrten Tage';
$lang['appointment_error_loading_invoice'] = 'Fehler beim Laden der Rechnung';
$lang['appointment_error_loading_time_slots'] = 'Fehler beim Laden der Zeitslots';
$lang['appointment_no_html_generated'] = 'Kein HTML generiert';
$lang['appointment_no_working_hours_data'] = 'Keine Arbeitszeiten Daten verfügbar';

// Tooltip messages
$lang['appointment_available_date_tooltip'] = 'Dieses Datum ist für Buchungen verfügbar';
$lang['appointment_blocked_date_tooltip'] = 'Dieses Datum ist gesperrt und nicht verfügbar für Buchungen';
$lang['appointment_past_date_tooltip'] = 'Vergangene Daten können nicht ausgewählt werden';

// Notification messages
$lang['appointment_marked_as_completed'] = 'Ein Termin wurde als abgeschlossen markiert';
$lang['appointment_marked_as_cancelled'] = 'Ein Termin wurde als storniert markiert';

// Provider assignments
$lang['appointment_provider_assigned'] = 'Anbieter dem Termin zugewiesen';
$lang['appointment_provider_removed'] = 'Anbieter vom Termin entfernt';

// Time and date terms
$lang['timezone'] = 'Zeitzone';
$lang['minutes'] = 'Minuten';
$lang['hours'] = 'Stunden';
$lang['monday'] = 'Montag';
$lang['tuesday'] = 'Dienstag';
$lang['wednesday'] = 'Mittwoch';
$lang['thursday'] = 'Donnerstag';
$lang['friday'] = 'Freitag';
$lang['saturday'] = 'Samstag';
$lang['sunday'] = 'Sonntag';
$lang['today'] = 'Heute';
$lang['this_week'] = 'Diese Woche';
$lang['this_month'] = 'Diesen Monat';
$lang['this_year'] = 'Dieses Jahr';
$lang['date_range'] = 'Datumsbereich';
$lang['custom_range'] = 'Benutzerdefinierter Bereich';
$lang['filter'] = 'Filter';

// ----------------------
// APPOINTMENT BASICS
// ----------------------
$lang['appointment_back_to_appointments'] = 'Termine';
$lang['appointment_create_new_appointment'] = 'Eine Beratung planen';
$lang['appointment_select_contact'] = 'Kontakt auswählen';
$lang['appointment_new_appointment'] = 'Termin erstellen';
$lang['appointment_edit_appointment'] = 'Termin aktualisieren';
$lang['appointment_save_changes_btn_label'] = 'Änderungen speichern';
$lang['appointment_subject'] = 'Besprechungszweck';
$lang['appointment_description'] = 'Sitzungsübersicht';
$lang['appointment_overview'] = 'Terminübersicht';
$lang['appointment_additional_info'] = 'Zusätzliche Informationen';
$lang['appointment_date'] = 'Datum';
$lang['appointment_time'] = 'Bevorzugte Uhrzeit';
$lang['appointment_date_and_time'] = 'Datum / Uhrzeit';
$lang['appointment_date_time'] = 'Datum & Uhrzeit';
$lang['appointment_meeting_date'] = 'Termindatum';
$lang['appointment_meeting_time'] = 'Termindatum';
$lang['appointments_reminders_label'] = 'Erinnerungen';
$lang['appointment_meeting_location'] = 'Ort';
$lang['appointment_location'] = 'Ort';
$lang['appointment_location_address'] = 'Ort / Adresse';
$lang['appointment_location_placeholder'] = 'Standortdetails eingeben';
$lang['appointment_duration'] = 'Termindauer';
$lang['appointment_duration_label'] = 'Dauer';
$lang['appointment_duration_help'] = 'Termindauer in Minuten festlegen';
$lang['appointment_notes'] = 'Notizen';
$lang['appointment_private_notes'] = 'Private Notizen';
$lang['appointment_client_notes'] = 'Terminnotizen';
$lang['appointment_created_by'] = 'Erstellt von';
$lang['appointly_created_at'] = 'Erstellt am';
$lang['appointment_schedule_details'] = 'Terminplan';
$lang['appointment_additional_settings'] = 'Zusätzliche Einstellungen';

// Appointment Status
$lang['appointment_status'] = 'Status';
$lang['appointment_status_text'] = 'Terminstatus';
$lang['appointment_status_pending'] = 'Ausstehend';
$lang['appointment_status_in-progress'] = 'In Bearbeitung';
$lang['appointment_status_completed'] = 'Abgeschlossen';
$lang['appointment_status_cancelled'] = 'Storniert';
$lang['appointment_status_no-show'] = 'Nichterscheinen';
$lang['appointment_upcoming'] = 'Bevorstehend';
$lang['appointment_finished'] = 'Beendet';
$lang['appointment_ongoing'] = 'In Bearbeitung';
$lang['appointment_cancelled'] = 'Storniert';
$lang['appointment_rescheduled'] = 'Verschoben';
$lang['appointment_no_show'] = 'Nichterscheinen';
$lang['appointment_missed_label'] = 'Verpasst';
$lang['appointment_pending_approval'] = 'Genehmigung ausstehend';
$lang['appointment_not_approved'] = 'Genehmigung ausstehend';
$lang['appointment_pending_cancellation'] = 'Stornierung ausstehend';
$lang['appointment_cancelled_text'] = 'Termin storniert';
$lang['appointment_missed'] = 'Termin verpasst (Termindatum/-uhrzeit liegt in der Vergangenheit)';
$lang['appointment_are_you_sure_mark_as_no_show'] = 'Sind Sie sicher, dass Sie diesen Termin als Nichterscheinen markieren möchten?';
$lang['appointment_completed'] = 'Abgeschlossen';
$lang['appointment_internal'] = 'Intern';
$lang['appointment_external'] = 'Extern';
$lang['appointment_lead_related'] = 'Lead';
$lang['appointment_internal_staff'] = 'Mitarbeiter';

// Status and Action Buttons
$lang['appointment_approve'] = 'Genehmigen';
$lang['appointment_approved'] = 'Genehmigt';
$lang['appointment_mark_as_finished'] = 'Als beendet markieren';
$lang['appointment_mark_as_ongoing'] = 'Als laufend markieren';
$lang['appointment_mark_as_cancelled'] = 'Storniert';
$lang['appointment_mark_as_rescheduled'] = 'Als verschoben markieren';
$lang['appointment_mark_as_no_show'] = 'Als Nichterscheinen markieren';
$lang['appointment_cancel'] = 'Termin stornieren';
$lang['appointment_description_to_cancel'] = 'Bitte beschreiben Sie, warum Sie diesen Termin stornieren möchten';
$lang['appointment_describe_reason_for_cancel'] = 'Beschreibung ist erforderlich. Bitte beschreiben Sie den Grund für die Stornierung des Termins?';
$lang['appointment_request_to_cancel'] = 'Stornierung anfordern';
$lang['appointment_request_cancellation'] = 'Stornierung anfordern';
$lang['appointment_approve_cancellation'] = 'Stornierung genehmigen';
$lang['appointment_marked_as_no_show'] = 'Als Nichterscheinen markiert';
$lang['appointly_are_you_sure_mark_as_no_show'] = 'Sind Sie sicher, dass Sie diesen Termin als Nichterscheinen markieren möchten?';

$lang['appointment_you_have_new_appointment'] = 'Sie haben einen neuen Termin';
$lang['appointment_initiated_by'] = 'Organisator';
$lang['appointment_select_single_contact'] = 'Kontakt';
$lang['appointment_deleted'] = 'Termin wurde erfolgreich gelöscht';
$lang['appointment_created'] = 'Neuer Termin wurde erfolgreich erstellt';
$lang['appointment_updated'] = 'Termin wurde erfolgreich aktualisiert';
$lang['appointment_appointment_approved'] = 'Termin wurde erfolgreich genehmigt!';
$lang['appointment_no_appointments'] = 'Sie haben heute keine Termine';
$lang['appointment_please_wait'] = 'Bitte warten...';
$lang['appointment_no_assigned_staff_found'] = 'Keine zugewiesenen Teilnehmer für diesen Termin gefunden';
$lang['appointment_cancel_notification'] = 'Kunde hat Terminabsage angefordert';
$lang['appointment_marked_as_finished'] = 'Termin als beendet markiert';
$lang['appointment_todays_appointments'] = 'Heutige Termine';
$lang['appointment_scheduled_at'] = 'Geplant am:';
$lang['appointment_view_meeting'] = 'Termin anzeigen';
$lang['appointment_edit_meeting'] = 'Termin bearbeiten';
$lang['appointment_dismiss_meeting'] = 'Termin löschen';
$lang['appointment_not_exists'] = 'Termin nicht gefunden, Weiterleitung zur Terminliste';
$lang['appointment_marked_as_ongoing'] = 'Termin als laufend markiert';
$lang['appointment_general_info'] = 'Kundendetails';
$lang['appointment_general_details'] = 'Termindetails';
$lang['appointment_source'] = 'Typ';
$lang['appointment_source_external_text'] = 'Extern (Kontakt)';
$lang['appointment_source_external'] = 'Quelle (Externer Kontakt)';
$lang['appointment_source_external_contact'] = 'Externer Kontakt';
$lang['appointment_source_internal'] = 'Intern (Kontakt)';
$lang['appointment_lead_required'] = 'Bitte wählen Sie einen Lead für den Termin aus';
$lang['appointment_source_internal_client'] = 'Intern (Kontakt)';
$lang['appointment_source_internal_staff'] = 'Intern (Mitarbeiter)';
$lang['appointment_source_lead'] = 'Lead';
$lang['appointment_staff_only'] = 'Nur Mitarbeiter';
$lang['appointment_phone'] = 'Telefon';
$lang['appointment_name'] = 'Name';
$lang['appointment_email'] = 'E-Mail';
$lang['appointment_contact'] = 'Kundendetails';
$lang['appointment_sent_successfully'] = 'Ihre neue Terminanfrage wurde erfolgreich gesendet, Sie werden per E-Mail benachrichtigt, wenn Ihr Termin genehmigt wird';
$lang['appointment_squeduled_at_text'] = 'Termin geplant um zu beginnen um';
$lang['appointment_staff_attendees'] = 'Teilnehmer';
$lang['appointment_is_approved'] = 'Termin wurde genehmigt!';
$lang['appointment_public_url'] = 'Öffentliche URL';
$lang['appointment_is_cancelled'] = 'Termin wurde storniert!';
$lang['appointment_cancel_notes'] = 'Stornierungsnotizen';
$lang['appointment_full_name'] = 'Kundenname';
$lang['appointment_your_email'] = 'Ihre E-Mail';
$lang['appointment_your_phone'] = 'Telefon (mit Ländervorwahl)';
$lang['appointment_your_phone_example'] = '+1 69 1234 5678';
$lang['appointment_submit'] = 'Senden';
$lang['appointment_no_staff_members'] = 'Es wurden keine Mitarbeiter gefunden. Sie sollten einen Mitarbeiter hinzufügen und diese Ansicht neu laden, um eine Person für neue Termine auszuwählen, die über das iFrame-Formular eingereicht wurden.';
$lang['appointment_cancellation_description_label'] = 'Stornierungsgrund';
$lang['appointments_thank_you_cancel_request'] = 'Vielen Dank für Ihre Stornierungsanfrage. Wir werden sie in Kürze prüfen.';
$lang['appointments_already_applied_for_cancelling'] = 'Sie haben bereits eine Stornierung für diesen Termin beantragt.';
$lang['appointment_pending_cancellations'] = 'Ausstehende Stornierungsanfragen';
$lang['appointment_requested_by'] = 'Angefordert von';
$lang['appointment_cancellation_approved'] = 'Stornierungsanfrage erfolgreich genehmigt';
$lang['appointly_schedule_new_appointment'] = 'Termin planen';
$lang['appointments_total_found'] = 'Gesamtzahl der Termine';
$lang['appointments_admin_label'] = 'Administrator';
$lang['appointments_staff_label'] = 'Mitarbeiter';
$lang['appointments_no_delete_permissions'] = 'Dieser Termin wurde nicht von Ihnen erstellt, kann nicht gelöscht werden';
$lang['appointment_source_external_clients_area'] = 'Quelle (Aus dem Kundenbereich bestehender Kontakt)';
$lang['appointments_source_external_label'] = 'Extern';
$lang['appointments_source_internal_label'] = 'Intern';
$lang['appointments_individual_contact'] = ' (Einzelner Kontakt)';
$lang['appointments_company_for_select'] = ' - Kunde ';
$lang['appointment_preview_url_label'] = 'Vorschau';
$lang['appointment_booking_form_services'] = 'Buchungsformular Dienste';
$lang['appointment_source_leads_label'] = 'Leads';
$lang['appointment_connect'] = 'Verbinden';
$lang['appointment_connected'] = 'Verbunden';
$lang['appointments_outlook_revoke_confirm'] = 'Von Outlook abmelden';
$lang['appointment_selected_service'] = 'Ausgewählter Dienst';
$lang['appointment_please_enter_your_details'] = 'Bitte geben Sie Ihre Daten ein';
$lang['appointments_request_feedback_from_client'] = 'Feedback vom Kunden anfordern';
$lang['appointments_request_feedback'] = 'Feedback anfordern';
$lang['appointment_feedback_label'] = 'Feedback';
$lang['appointment_view_feedback'] = 'Feedback anzeigen';
$lang['appointment_feedback_label_added'] = 'Vielen Dank für Ihr Feedback!';
$lang['appointment_feedback_label_current'] = 'Ihr aktuell gegebenes Feedback!';
$lang['appointments_feedback_info'] = 'Ihre Standard-Feedback-Status verwalten';
$lang['ap_feedback_extremely_good'] = 'Extrem gut';
$lang['ap_feedback_very_good'] = 'Sehr gut';
$lang['ap_feedback_good'] = 'Gut';
$lang['ap_feedback_not_bad'] = 'Nicht schlecht';
$lang['ap_feedback_bad'] = 'Schlecht';
$lang['ap_feedback_the_worst'] = 'Am schlechtesten';
$lang['ap_feedback_not_sure'] = 'Nicht sicher';
$lang['appointment_feedback_title'] = 'Hinterlassen Sie Ihr Feedback zu diesem Termin';
$lang['appointmenet_feedback_comment'] = 'Ihre Kommentare und Gedanken zu diesem Termin: ';
$lang['appointment_feedback_comment_textarea'] = 'Es sind mindestens ein paar Worte erforderlich, um Ihre Erfahrung mit diesem Termin zu beschreiben';
$lang['appointment_feedback_comment_textarea_info'] = 'Bitte beschreiben Sie Ihre Erfahrung mit diesem Termin';
$lang['appointment_new_feedback_added'] = 'Sie haben ein neues Feedback für einen Termin';
$lang['appointly_feedback_updated'] = 'Feedback-Bewertung wurde gerade aktualisiert';
$lang['appointment_email_tracking'] = 'E-Mail-Tracking (wird die Termin-E-Mail gelesen)';
$lang['appointment_feedback_requested_alert'] = 'Feedback wurde erfolgreich angefordert, Sie werden per E-Mail benachrichtigt, wenn Feedback gegeben wird!';
$lang['appointment_click_to_change_rating'] = 'Klicken Sie auf die Sterne, um Ihre Bewertung zu aktualisieren';
$lang['appointment_staff_cant_provide_feedback'] = 'Mitarbeiter können kein Feedback zu Terminen geben';
$lang['appointment_leave_feedback'] = 'Bewerten Sie Ihre Erfahrung mit diesem Termin';
$lang['appointment_your_feedback'] = 'Ihr Feedback';
$lang['appointment_no_feedback_provided'] = 'Der Kunde hat für diesen Termin noch kein Feedback gegeben';
$lang['appointments_are_you_sure_request_feedback'] = 'Sind Sie sicher, dass Sie Feedback für diesen Termin anfordern möchten? Eine E-Mail wird an den Kunden gesendet.';

// Client Area
$lang['appointly_allow_non_logged_clients_appointment'] = 'Nicht angemeldeten Kunden erlauben, neue Termine über das externe Buchungsformular anzufordern';
$lang['appointly_show_appointments_menu_item_in_clients_area'] = 'Menüpunkt für Terminanfragen im Kundenbereich anzeigen (wenn angemeldet)';
$lang['appointments_applies_for_clients'] = '(gilt nur für Kunden)';

// ----------------------
// TIME SLOTS & AVAILABILITY
// ----------------------
$lang['appointly_no_providers_for_service'] = 'Keine Anbieter für diesen Dienst verfügbar';
$lang['appointly_no_providers_with_hours'] = 'Keine Anbieter mit verfügbaren Arbeitszeiten für diesen Dienst';
$lang['appointly_select_staff'] = 'Mitarbeiter auswählen';
$lang['appointment_busy_hours'] = 'Belegte Stunden';
$lang['appointment_available_hours'] = 'Verfügbare Stunden';
$lang['appointment_meeting_hour_is_reserved'] = 'Terminstunde ist bereits reserviert';
$lang['appointment_requested_hour'] = 'Angefragte Besprechungsstunde';
$lang['appointment_time_unavailable'] = 'Dieser Zeitfenster ist nicht verfügbar';
$lang['appointment_date_blocked'] = 'Dieses Datum ist vom Administrator gesperrt';
$lang['appointly_available_time_slots'] = 'Verfügbare Zeitfenster';
$lang['appointment_available_time_slots'] = 'Verfügbare Zeitfenster';
$lang['appointment_no_slots_available'] = 'Keine verfügbaren Zeitfenster für diesen Tag';
$lang['appointment_slot_already_booked'] = 'Dieses Zeitfenster ist bereits gebucht';
$lang['appointment_unavailable_slots_shown'] = 'Nicht verfügbare Zeitfenster werden rot angezeigt und können nicht ausgewählt werden';
$lang['appointment_all_slots_booked'] = 'Alle Zeitfenster für diesen Tag sind gebucht. Bitte versuchen Sie ein anderes Datum.';
$lang['appointment_slot_unavailable'] = 'Dieser Zeitfenster ist nicht verfügbar';
$lang['appointment_checking_availability'] = 'Verfügbarkeit wird geprüft...';
$lang['appointment_checking_time_slots'] = 'Zeitfenster werden geladen...';
$lang['appointment_error_loading_slots'] = 'Fehler beim Laden der Zeitfenster. Bitte versuchen Sie es erneut.';
$lang['appointment_not_available'] = 'Nicht verfügbar';
$lang['appointment_available'] = 'Verfügbar';

// Schedule and calendar
$lang['appointment_recurring'] = 'Wiederkehrend';
$lang['appointment_recurring_re_created'] = 'Wiederkehrender Termin wurde neu erstellt';
$lang['appointments_all_day_event'] = 'Ganztägiges Ereignis';
$lang['select_blocked_days'] = 'Tage auswählen';
$lang['appointments_blocked_days_on_calendar_title'] = 'Gesperrte Tage<br><small class="text-muted">Wählen Sie Daten aus, an denen keine Termine geplant werden können (Feiertage, Betriebsschließungen usw.).<br> Diese Daten sind sowohl für interne als auch für externe Buchungen nicht verfügbar.</small>';
$lang['appointments_dates_blocked_info_text'] = 'Die ausgewählten Daten sind im Buchungskalender nicht verfügbar. Besprechungen können an diesen Daten weder intern noch extern geplant werden.';
$lang['appointments_blocked_days_tab_title'] = 'Nicht-Arbeitstage';
$lang['appointments_blocked_days_on_calendar_info'] = 'Gesperrte Tage Kalender Informationen';

// Working Hours and Schedules
$lang['appointments_default_hours_label'] = 'Ihre Standard-Terminzeiten verwalten';
$lang['appointly_company_schedule'] = 'Unternehmenszeitplan';
$lang['appointly_company_schedule_info'] = 'Konfigurieren Sie die Standardarbeitszeiten für Ihr Unternehmen. Diese Zeiten werden für alle Mitarbeiter verwendet, es sei denn, sie haben ihre eigenen spezifischen Arbeitszeiten festgelegt.';
$lang['appointly_manage_company_schedule'] = 'Unternehmenszeitplan verwalten';
$lang['appointly_staff_working_hours'] = 'Arbeitszeiten des Personals';
$lang['appointly_staff_working_hours_info'] = 'Konfigurieren Sie die Arbeitszeiten für diesen Mitarbeiter. Diese Zeiten überschreiben den Unternehmenszeitplan, wenn dieser Mitarbeiter als Anbieter ausgewählt wird.';
$lang['appointly_view_staff_schedule'] = 'Mitarbeiterzeitplan anzeigen';
$lang['appointly_day'] = 'Tag';
$lang['appointly_enabled'] = 'Aktiviert';
$lang['appointly_available'] = 'Verfügbar';
$lang['appointly_start_time'] = 'Startzeit';
$lang['appointly_end_time'] = 'Endzeit';
$lang['appointly_use_company_schedule'] = 'Unternehmenszeitplan verwenden';
$lang['appointly_use_company_schedule_tooltip'] = 'Aktivieren Sie diese Option, um die Einstellungen des Unternehmenszeitplans für diesen Tag anstelle benutzerdefinierter Einstellungen zu verwenden.';
$lang['appointly_day_monday'] = 'Montag';
$lang['appointly_day_tuesday'] = 'Dienstag';
$lang['appointly_day_wednesday'] = 'Mittwoch';
$lang['appointly_day_thursday'] = 'Donnerstag';
$lang['appointly_day_friday'] = 'Freitag';
$lang['appointly_day_saturday'] = 'Samstag';
$lang['appointly_day_sunday'] = 'Sonntag';
$lang['appointly_at_least_one_day_required'] = 'Mindestens ein Tag muss aktiviert sein';
$lang['appointly_no_working_hours_found'] = 'Für diesen Anbieter wurden keine Arbeitszeiten festgelegt';
$lang['appointly_closed'] = 'Geschlossen';
$lang['appointly_working_hours'] = 'Arbeitszeiten';
$lang['company_schedule_time_intervals_note'] = 'Zeiten können nur in 15-Minuten-Intervallen eingestellt werden (z. B. 09:00, 09:15, 09:30, 09:45)';
$lang['working_hours_time_intervals_note'] = 'Zeitfenster sind in 15-Minuten-Intervallen verfügbar';
$lang['appointly_time_error'] = 'Startzeit muss vor Endzeit liegen für';
$lang['appointly_company_schedule_sync_help'] = 'Mitarbeiter können die Option „Unternehmenszeitplan verwenden“ nutzen, um ihre Arbeitszeiten mit den Unternehmensstandards zu synchronisieren.';

// Buffer settings
$lang['appointly_settings_buffer_times'] = 'Pufferzeiten zwischen Terminen aktivieren';
$lang['appointly_settings_buffer_times_info'] = 'Pufferzeiten ermöglichen Übergangszeiten zwischen Terminen';
$lang['appointly_buffer_before'] = 'Puffer vor (Minuten)';
$lang['appointly_buffer_after'] = 'Puffer nach (Minuten)';
$lang['appointly_buffer_before_help'] = 'Zusätzliche Zeit vor dem Termin zur Vorbereitung';
$lang['appointly_buffer_after_help'] = 'Zusätzliche Zeit nach dem Termin zum Aufräumen';

// ----------------------
// SERVICES & PROVIDERS
// ----------------------
$lang['appointly_services'] = 'Dienste';
$lang['service'] = 'Dienst';
$lang['appointment_service'] = 'Dienst';
$lang['appointment_services'] = 'Dienste';
$lang['appointment_select_service'] = 'Dienst auswählen';
$lang['appointment_service_duration'] = 'Dauer';
$lang['appointment_service_price'] = 'Preis';
$lang['appointment_service_description'] = 'Beschreibung';
$lang['appointments_service_heading'] = 'Dienst';
$lang['appointments_staff_heading'] = 'Mitarbeiter';
$lang['service_selection_required'] = 'Bitte wählen Sie einen Dienst aus';
$lang['appointment_service_required'] = 'Bitte wählen Sie einen Dienst für den Termin aus';
$lang['appointly_service_selection_label'] = 'Dienst';
$lang['appointments_selected_service'] = 'Ausgewählter Dienst';
$lang['no_services_available'] = 'Keine Dienste verfügbar';

// Service Creation and Management
$lang['appointly_new_service'] = 'Neuer Dienst';
$lang['appointly_edit_service'] = 'Dienst bearbeiten';
$lang['appointly_service_add_success'] = 'Dienst erfolgreich hinzugefügt';
$lang['appointly_service_edit_success'] = 'Dienst erfolgreich aktualisiert';
$lang['appointly_service_delete_success'] = 'Dienst erfolgreich gelöscht';
$lang['appointly_service_delete_error'] = 'Dienst konnte nicht gelöscht werden';
$lang['error_adding_service'] = 'Dienst konnte nicht hinzugefügt werden';
$lang['error_updating_service'] = 'Dienst konnte nicht aktualisiert werden';
$lang['service_delete_error_active'] = 'Dienst ist aktiv und kann nicht gelöscht oder deaktiviert werden.';
$lang['appointly_service_in_use_warning'] = 'Dieser Dienst wird derzeit in einem oder mehreren Terminen verwendet und kann nicht gelöscht oder deaktiviert werden.';

// Service Properties
$lang['service_availability_days'] = 'Verfügbare Tage';
$lang['service_hours_start'] = 'Arbeitszeiten Beginn';
$lang['service_hours_end'] = 'Arbeitszeiten Ende';
$lang['appointly_service_name'] = 'Name';
$lang['appointly_service_name_label'] = 'Dienstname';
$lang['appointly_service_duration'] = 'Dauer';
$lang['appointly_service_price'] = 'Preis';
$lang['appointly_service_color'] = 'Farbe';
$lang['appointly_service_description'] = 'Beschreibung';
$lang['appointly_service_active'] = 'Aktiv';
$lang['appointly_service_details'] = 'Dienstdetails';
$lang['appointly_service_back_to_list'] = 'Zurück zur Dienstliste';
$lang['appointly_duration_validation'] = 'Dauer muss in Intervallen von 15 Minuten (15, 30, 45 usw.) und maximal 480 Minuten liegen';
$lang['appointly_price_validation'] = 'Preis darf nicht negativ sein';
$lang['appointly_duration_minutes'] = 'Minuten';
$lang['appointly_service_staff'] = 'Anbieter/Mitarbeiter zugewiesen';
// Service Validation
$lang['service_name_required'] = 'Dienstname ist erforderlich';
$lang['service_duration_required'] = 'Dienstdauer ist erforderlich';
$lang['service_duration_numeric'] = 'Dauer muss eine Zahl sein';
$lang['service_duration_greater'] = 'Dauer muss größer als 0 sein';
$lang['service_price_required'] = 'Dienstpreis ist erforderlich';
$lang['service_price_greater_equal'] = 'Preis muss 0 oder größer sein';
$lang['service_days_required'] = 'Bitte wählen Sie mindestens einen verfügbaren Tag aus';
$lang['service_hours_required'] = 'Dienstzeiten sind erforderlich';
$lang['service_hours_invalid'] = 'Ungültiges Zeitformat';
$lang['service_hours_start_end'] = 'Endzeit muss nach Startzeit liegen';
$lang['appointly_staff_required'] = 'Bitte wählen Sie einen Mitarbeiter aus';
$lang['appointly_working_hours_required'] = '%s Arbeitszeiten sind erforderlich.';
$lang['appointly_working_hours_invalid'] = '%s Endzeit muss nach Startzeit liegen.';
$lang['appointly_working_hours_at_least_one'] = 'Mindestens ein Tag muss aktiviert sein.';

// Service Table Headers
$lang['service_th_name'] = 'Name';
$lang['service_th_duration'] = 'Dauer (Minuten)';
$lang['service_th_price'] = 'Preis';
$lang['service_th_availability'] = 'Verfügbarkeit';
$lang['service_th_status'] = 'Status';
$lang['service_th_options'] = 'Optionen';

// Service Status
$lang['service_status_active'] = 'Aktiv';
$lang['service_status_inactive'] = 'Inaktiv';
$lang['service_status_changed_success'] = 'Dienststatus erfolgreich aktualisiert';
$lang['service_status_changed_error'] = 'Dienststatus konnte nicht aktualisiert werden';
$lang['service_toggle_active'] = 'Aktiven Status umschalten';
$lang['error_updating_status'] = 'Fehler beim Aktualisieren des Status. Bitte versuchen Sie es erneut.';
$lang['service_status_updated'] = 'Dienststatus erfolgreich aktualisiert';
$lang['service_status_update_failed'] = 'Dienststatus konnte nicht aktualisiert werden';

// Providers
$lang['appointment_provider'] = 'Anbieter';
$lang['appointly_provider'] = 'Anbieter';
$lang['service_provider_loading'] = 'Verfügbare Anbieter werden geladen...';
$lang['service_no_providers'] = 'Keine Anbieter für diesen Dienst verfügbar';
$lang['service_provider_select'] = 'Anbieter auswählen';
$lang['appointment_select_provider'] = 'Anbieter auswählen';
$lang['appointly_select_provider'] = 'Anbieter auswählen';
$lang['appointly_no_staff'] = 'Keine Mitarbeiter verfügbar';
$lang['appointly_error_loading_schedule'] = 'Fehler beim Laden des Anbieterzeitplans';
$lang['appointment_no_provider_assigned'] = 'Kein Anbieter zugewiesen';
$lang['appointly_meeting_location'] = 'Besprechungsort';

// Multiple Providers
$lang['appointly_settings_multi_providers'] = 'Mehrere Anbieter pro Dienst aktivieren';
$lang['appointly_settings_multi_providers_info'] = 'Erlauben, dass Dienste von mehreren Mitarbeitern erbracht werden';
$lang['appointly_primary_provider'] = 'Primärer Anbieter';
$lang['appointly_add_provider'] = 'Anbieter hinzufügen';
$lang['appointly_remove_provider'] = 'Anbieter entfernen';
$lang['appointly_service_providers'] = 'Dienstanbieter';
$lang['appointly_confirm_provider_removal'] = 'Sind Sie sicher, dass Sie diesen Anbieter entfernen möchten?';
$lang['appointly_assigned_providers'] = 'Zugewiesene Anbieter';
$lang['appointly_service_primary_provider'] = 'Primärer Anbieter';
$lang['appointment_external_provider'] = 'Externer Anbieter';

// ----------------------
// NOTIFICATIONS & REMINDERS
// ----------------------
$lang['appointment_modal_notification_info'] = 'Bitte markieren Sie die Kontrollkästchen, wenn Sie möchten, dass ausgewählte Teilnehmer und Kontakte Erinnerungen erhalten, z. B. wenn 30 Minuten vor Beginn des Termins eingestellt. Beachten Sie, dass diese Funktion einen konfigurierten Cronjob erfordert.';
$lang['appointment_sms_notification_text'] = 'SMS-Benachrichtigungen senden';
$lang['appointment_email_notification_text'] = 'E-Mail-Benachrichtigungen senden';
$lang['appointment_send_notification'] = 'Benachrichtigung jetzt senden';
$lang['appointment_notified'] = 'Terminerinnerungen';
$lang['appointment_notified_by_sms'] = 'Erinnerungsbenachrichtigung per SMS ausgelöst';
$lang['appointment_notified_by_email'] = 'Erinnerungsbenachrichtigung per E-Mail ausgelöst';
$lang['appointment_send_early_reminders_label'] = 'Frühe Erinnerungen senden';
$lang['appointly_are_you_early_reminders'] = 'Sind Sie sicher, dass Sie frühe Terminerinnerungen senden möchten?';
$lang['appointly_reminders_sent'] = 'Terminerinnerungen wurden an alle Teilnehmer und Kontakte gesendet';
$lang['appointment_manually_send_reminders_info'] = 'Manuell Benachrichtigungserinnerungen an alle Teilnehmer senden';
$lang['appointment_early_reminders_notice_label'] = 'Termin ist weder storniert noch beendet, um frühe Erinnerungen zu senden';
$lang['appointment_email_read_at'] = 'Gelesen am: ';
$lang['appointment_email_not_read'] = 'Nicht gelesen';
$lang['appoontment_sms_notification'] = 'SMS-Benachrichtigung';
$lang['appoontment_email_notification'] = 'E-Mail-Benachrichtigung';

// ----------------------
// CALENDAR INTEGRATIONS
// ----------------------
// Google Calendar
$lang['appointly_calendar_integrations'] = 'Kalenderintegrationen';
$lang['appointment_add_to_google_calendar'] = 'Zu Google Kalender hinzufügen';
$lang['appointments_google_already_signed'] = 'Sie sind bereits in Ihrem Google-Konto angemeldet.';
$lang['appointments_added_to_google_calendar'] = 'Zu Google Kalender hinzugefügt';
$lang['appointments_sign_in_google'] = 'Mit Google anmelden';
$lang['appointments_google_revoke_confirm'] = 'Von Google abmelden';
$lang['appointments_google_revoke'] = 'Aktuelle Google Kalender-Sitzung widerrufen und alle Berechtigungen, die Ihrem Google-Konto erteilt wurden, entfernen.';
$lang['appointments_google_calendar_client_id'] = 'Google Kalender API Client ID <strong>(abgerufen aus Einstellungen->Google->API CLIENT ID)</strong>';
$lang['appointments_google_calendar_settings'] = 'Google Kalender API-Einstellungen';
$lang['appointments_google_calendar_client_secret'] = 'Google Kalender API-Geheimnis';
$lang['appointments_redirect_url'] = 'Google Autorisierungs-Weiterleitungs-URI';
$lang['appointly_show_google_appointments_from'] = 'Termine nach Datumsbereich filtern:';
$lang['appointments_delete_from_google_label'] = 'Bevor der Termin gelöscht wird, löschen Sie auch den erstellten Termin in Ihrem Google Kalender <small>(Gilt nur, wenn Google Kalender aktiviert und synchronisiert ist)</small>';
$lang['appointment_add_to_google_calendar_external'] = 'Diesen externen Termin zu Ihrem Google Kalender hinzufügen (Ankreuzen und Speichern klicken)';
$lang['appointment_open_google_calendar'] = 'In Google Kalender öffnen';
$lang['appointment_google_not_added_yet'] = 'Es scheint, dass dieser Termin noch nicht zum Google Kalender eines Mitarbeiters hinzugefügt wurde. Möchten Sie diesen Termin zu Ihrem Google Kalender hinzufügen?';
$lang['appointment_add_to_calendar'] = 'Zum Kalender hinzufügen';
$lang['appointment_view_in_calendar'] = 'In Google Kalender anzeigen';
$lang['appointment_calendar_adding_to_google'] = 'Wird zu Google Kalender hinzugefügt...';
$lang['appointment_error_adding_to_calendar'] = 'Konnte nicht zum Kalender hinzugefügt werden. Bitte versuchen Sie es erneut.';
$lang['event_not_found_in_google'] = 'Ereignis existiert möglicherweise nicht in Google Kalender';
$lang['appointments_delete_from_google_calendar'] = 'Aus Google Kalender löschen';
$lang['appointments_synced_from_google'] = 'Von Google synchronisiert';
$lang['appointments_googlesync_show_in_table_label'] = 'Wenn die Google Kalender-Integration aktiv ist, alle Google Kalender-Termine in der Standardtabellenansicht anzeigen.';
$lang['appointly_google_synced_title'] = ' Google synchronisiert';
$lang['appointment_hide_google_calendar'] = 'Standardansicht anzeigen';
$lang['appointment_google_calendar_synced'] = 'Google Kalender synchronisiert';
$lang['appointment_googlesync_only_today'] = 'Heute';
$lang['appointment_googlesync_only_last_month'] = 'Letzten Monat';
$lang['appointment_googlesync_only_last_three_months'] = 'Letzte 3 Monate';
$lang['appointment_googlesync_only_last_six_months'] = 'Letzte 6 Monate';
$lang['appointment_googlesync_only_last_year'] = 'Letztes Jahr';
$lang['appointment_googlesync_show_all'] = 'Alle';
$lang['appointly_not_including_two_way_synced_appointments'] = 'Zwei-Wege-synchronisierte Termine nicht enthalten';
$lang['appointment_external_calendar_event'] = 'Externes Kalenderereignis';

// Google Meet
$lang['appointment_google_meet_info'] = 'Dieser Termin wird zu Google Kalender hinzugefügt, Sie können Google Meet verwenden, um sich online mit Ihren Kunden zu treffen';
$lang['appointment_google_meet_info_2'] = 'Dieser Termin wird zu Google Kalender hinzugefügt';
$lang['appointment_google_client_meet_info'] = 'Über Google Meet verbinden';
$lang['appointment_connect_via_google_meet'] = 'Ich möchte mich über Google Meet verbinden';
$lang['appointment_meet_message'] = 'Hallo<br><br>Bitte folgen Sie dieser URL, um sich über Google Meet mit mir zu verbinden: ';
$lang['appointment_meeting_request_sent'] = 'Ihre Besprechungsanfrage wurde erfolgreich gesendet';
$lang['appointment_leave_a_comment'] = 'Möchten Sie einen Kommentar hinterlassen';
$lang['appointment_google_meet_connect_message'] = 'E-Mail an Teilnehmer senden und bitten, sich über Google Meet zu verbinden';
$lang['appointment_google_meet_modal_custom_label'] = 'Mitarbeiter und Kunden per E-Mail zu Google Meet einladen';
$lang['appointment_google_meet'] = 'Google Meet';
$lang['appointment_google_calendar'] = 'Google Kalender';

// Enhanced Google Meet Settings
$lang['appointment_google_meet_enhanced_settings'] = 'Erweiterte Google Meet-Einstellungen';
$lang['appointly_auto_enable_google_meet'] = 'Google Meet für alle Termine automatisch aktivieren';
$lang['appointly_auto_enable_google_meet_help'] = 'Wenn aktiviert, enthalten alle neuen Termine automatisch Google Meet-Links, wenn sie mit Google Kalender synchronisiert werden';
$lang['appointly_auto_add_to_google_on_approval'] = 'Automatisch zu Google Kalender hinzufügen bei Genehmigung externer Termine';
$lang['appointly_auto_add_to_google_on_approval_help'] = 'Wenn aktiviert, werden externe Termine automatisch zum Google Kalender des zugewiesenen Mitarbeiters hinzugefügt, wenn sie genehmigt werden';
$lang['appointly_google_meet_default_settings'] = 'Standard-Google Meet-Einstellungen';
$lang['appointly_google_meet_enable_recording'] = 'Aufnahme standardmäßig aktivieren';
$lang['appointly_google_meet_enable_waiting_room'] = 'Warteraum standardmäßig aktivieren';
$lang['appointly_google_meet_reminder_minutes'] = 'Standard-Erinnerungszeit vor der Besprechung';
$lang['appointly_google_meet_reminder_help'] = 'Standard-Erinnerungszeit für Google Meet-Termine festlegen';
$lang['appointly_disable_google_meeting_emails'] = 'Google Kalender-E-Mail-Benachrichtigungen deaktivieren';
$lang['appointly_disable_google_meeting_emails_help'] = 'Wenn aktiviert, sendet Google keine automatischen E-Mail-Benachrichtigungen für Kalenderereignisse';
$lang['appointly_minutes'] = 'Minuten';
$lang['appointly_hour'] = 'Stunde';
$lang['appointly_hours'] = 'Stunden';

// Enhanced Google Meet Features
$lang['appointment_google_meet_join_before_start'] = 'Google Meet beitreten';
$lang['appointment_google_meet_copy_link'] = 'Google Meet-Link kopieren';
$lang['appointment_google_meet_link_copied'] = 'Google Meet-Link in die Zwischenablage kopiert';
$lang['appointment_google_meet_test_connection'] = 'Google Meet-Verbindung testen';
$lang['appointment_google_meet_connection_success'] = 'Google Meet-Verbindungstest erfolgreich';
$lang['appointment_google_meet_connection_failed'] = 'Google Meet-Verbindungstest fehlgeschlagen';
$lang['appointment_google_meet_quick_join'] = 'Schnell an Besprechung teilnehmen';
$lang['appointment_google_meet_meeting_details'] = 'Besprechungsdetails';
$lang['appointment_google_meet_dial_in'] = 'Einwahlinformationen';
$lang['appointment_google_meet_share_screen'] = 'Bildschirmfreigabe verfügbar';
$lang['appointment_google_meet_record_meeting'] = 'Aufnahme verfügbar';
$lang['appointment_google_meet_waiting_room_enabled'] = 'Warteraum aktiviert';
$lang['appointment_google_meet_testing_connection'] = 'Google Meet-Verbindung wird getestet...';
$lang['appointment_google_meet_copy_failed'] = 'Kopieren fehlgeschlagen. Bitte manuell kopieren.';
$lang['appointment_google_meet_email_message'] = 'E-Mail-Nachricht';
$lang['appointment_google_meet_send_invitation'] = 'Google Meet-Einladung senden';
$lang['appointment_google_meet_message_required'] = 'Bitte geben Sie eine Nachricht zum Senden ein';
$lang['sending'] = 'Senden...';
$lang['appointment_email_send_failed'] = 'E-Mail-Versand fehlgeschlagen. Bitte überprüfen Sie Ihre E-Mail-Einstellungen.';
$lang['appointment_google_meet_send_to'] = 'Senden an';
$lang['appointment_google_meet_primary_recipient'] = 'Primärer Empfänger';
$lang['appointment_google_meet_also_notify_attendees'] = 'Auch Mitarbeiter-Teilnehmer benachrichtigen';
$lang['appointment_no_email_provided'] = 'Keine E-Mail-Adresse angegeben';
$lang['appointment_google_meet_hd_video_audio'] = 'HD Video & Audio';
$lang['appointment_google_meet_always_enabled'] = 'Immer aktiviert';
$lang['appointment_google_meet_recording_enabled'] = 'Aufnahme aktiviert';
$lang['appointment_google_meet_recording_disabled'] = 'Aufnahme deaktiviert';
$lang['appointment_google_meet_waiting_room_enabled_status'] = 'Warteraum aktiviert';
$lang['appointment_google_meet_waiting_room_disabled'] = 'Warteraum deaktiviert';
$lang['appointment_google_meet_quick_actions'] = 'Schnellaktionen';
$lang['appointment_google_meet_join_meeting'] = 'Google Meet beitreten';
$lang['appointment_google_meet_send_invitation_btn'] = 'Einladung senden';

// Google Maps
$lang['appointment_google_maps'] = 'In Google Maps öffnen';
$lang['appointly_google_maps_not_shown'] = 'Google Maps wird nicht angezeigt.';
$lang['appointly_google_api_key_notset'] = 'Google API-Schlüssel ist nicht festgelegt. Bitte legen Sie den Google API-Schlüssel in den Termineinstellungen fest';
$lang['appointly_message_will_hide'] = 'Diese Nachricht wird in 5 Sekunden ausgeblendet';

// Outlook Calendar
$lang['appointment_login_to_outlook'] = 'Bei Outlook anmelden';
$lang['appointment_logout_from_outlook'] = 'Von Outlook abmelden';
$lang['appointment_open_outlook_calendar'] = 'In Outlook Kalender öffnen';
$lang['appointments_outlook_revoke'] = 'Aktuelle Outlook Kalender-Sitzung widerrufen und alle Berechtigungen, die Ihrem Outlook-Konto erteilt wurden, entfernen.';
$lang['appointment_redirect_url_logout'] = 'Outlook Autorisierungs- und Weiterleitungs-URI';
$lang['appointment_outlook_api_label'] = 'Outlook Kalender API';
$lang['appointment_outlook_client_id'] = 'Anwendungs- (Client-) ID';
$lang['appointment_outlook_calendar'] = 'Outlook Kalender';
$lang['appointment_outlook_calendar_info'] = 'Dieser Termin wird zu Outlook Kalender hinzugefügt';
$lang['appointment_add_to_outlook'] = 'Zu Outlook Kalender hinzufügen';
$lang['appointment_outlook_not_added_yet'] = 'Noch nicht zu Outlook Kalender hinzugefügt';
$lang['appointment_is_added_to_outlook'] = 'Zu Outlook Kalender hinzugefügt';
$lang['appointment_calendar_adding_to_outlook'] = 'Wird zu Outlook Kalender hinzugefügt...';
$lang['appointment_added_to_outlook'] = 'Ereignis erfolgreich zu Outlook Kalender hinzugefügt';
$lang['appointment_added_to_outlook_but_not_saved'] = 'Ereignis zu Outlook hinzugefügt, aber Speichern in der Datenbank fehlgeschlagen';
$lang['appointment_outlook_event_saved'] = 'Outlook Ereignisdetails gespeichert';
$lang['appointment_outlook_event_save_failed'] = 'Fehler beim Speichern der Outlook Ereignisdetails';
$lang['appointment_outlook_error'] = 'Fehler beim Hinzufügen zu Outlook';
$lang['appointment_outlook_auth_error'] = 'Outlook Authentifizierungsfehler';
$lang['appointment_invalid_date'] = 'Ungültiges Termindatum';
$lang['appointment_sign_in_to_outlook'] = 'Bei Outlook anmelden';
$lang['appointment_sign_out_from_outlook'] = 'Von Outlook abmelden';
$lang['appointments_outlook_view_in_calendar'] = 'In Outlook Kalender anzeigen';
$lang['appointment_outlook_calendar_title'] = 'Outlook Kalender';
$lang['appointment_outlook_sync_status'] = 'Outlook Synchronisierungsstatus';
$lang['appointment_outlook_last_synced'] = 'Zuletzt synchronisiert: %s';
$lang['appointment_outlook_sync_error'] = 'Letzte Synchronisierung fehlgeschlagen: %s';
$lang['appointment_outlook_event_deleted'] = 'Outlook Ereignis erfolgreich gelöscht';
$lang['appointment_outlook_event_delete_failed'] = 'Fehler beim Löschen des Outlook Ereignisses';
$lang['appointments_table_calendar'] = 'Zu Kalendern hinzugefügt';
$lang['appointment_not_added_to_calendars_yet'] = 'Noch nicht zu einem Kalender hinzugefügt.';
$lang['permission_approve'] = 'Genehmigen';
$lang['permission_view_reports'] = 'Berichte anzeigen';
$lang['appointly_missing_required_fields'] = 'Fehlende Pflichtfelder';
$lang['appointly_service_not_found'] = 'Dienst nicht gefunden';
$lang['appointly_error_getting_time_slots'] = 'Fehler beim Abrufen verfügbarer Zeitfenster. Bitte versuchen Sie es erneut.';
$lang['appointly_invalid_working_hours'] = 'Ungültige Arbeitszeitenkonfiguration';
$lang['appointly_service_price_invalid'] = 'Dienstpreis muss eine gültige Zahl sein (0 oder größer)';
$lang['appointly_service_duration_invalid'] = 'Dienstdauer muss eine positive Zahl sein';
$lang['appointly_service_providers_required'] = 'Mindestens ein Dienstanbieter muss zugewiesen sein';
$lang['appointly_error_loading_providers'] = 'Fehler beim Laden der Anbieter';
$lang['appointly_no_data_available'] = 'Keine Daten verfügbar';
$lang['appointly_please_try_again'] = 'Bitte versuchen Sie es erneut';
$lang['appointly_installation_complete'] = 'Installation erfolgreich abgeschlossen';
$lang['appointly_database_updated'] = 'Datenbank erfolgreich aktualisiert';
$lang['appointly_menu_reset'] = 'Menü wurde erfolgreich zurückgesetzt';
$lang['appointly_default_service_created'] = 'Standarddienst erfolgreich erstellt';
$lang['appointly_working_hours_configured'] = 'Arbeitszeiten erfolgreich konfiguriert';
$lang['appointment_select_service_provider_first'] = 'Bitte wählen Sie zuerst Dienst und Anbieter aus';
$lang['appointment_are_you_sure_to_cancel'] = 'Sind Sie sicher, dass Sie diesen Termin stornieren möchten?';
$lang['appointment_are_you_sure_to_mark_as_ongoing'] = 'Sind Sie sicher, dass Sie diesen Termin als laufend markieren möchten?';
$lang['appointment_error_occurred'] = 'Ein Fehler ist aufgetreten. Bitte versuchen Sie es erneut.';
$lang['appointment_closed'] = 'Terminbuchung ist derzeit geschlossen';
$lang['appointment_time_required'] = 'Bitte wählen Sie ein Zeitfenster aus';
$lang['appointment_no_providers'] = 'Keine Anbieter für diesen Dienst verfügbar';
$lang['appointment_provider_not_available'] = 'Anbieter an diesem Tag nicht verfügbar';
$lang['appointment_minutes'] = 'Minuten';
$lang['appointment_unavailable'] = 'Nicht verfügbar';
$lang['is_required'] = 'ist erforderlich';
$lang['appointment_schedule_info'] = 'Terminplan';
$lang['appointment_form_info'] = 'Termininformationen';
$lang['appointment_marked_as_approved'] = 'Termin als genehmigt markiert';
$lang['appointment_cancellation_approval_failed'] = 'Fehler beim Genehmigen der Terminabsage';
$lang['appointment_send_an_sms'] = 'SMS senden';
$lang['appointment_call_number'] = 'Anrufen';
$lang['appointment_actions'] = 'Aktionen';
$lang['appointment_staff_cannot_provide_feedback'] = 'Mitarbeiter können kein Feedback zu Terminen geben';
$lang['appointment_thank_you_for_feedback'] = 'Vielen Dank für Ihr Feedback!';
$lang['appointment_feedback_comment_required'] = 'Feedback-Kommentar ist erforderlich';

// Reschedule functionality client side
$lang['appointment_reschedule'] = 'Verschieben';
$lang['appointment_reschedule_reason'] = 'Grund für die Verschiebung';
$lang['appointment_reschedule_reason_placeholder'] = 'Bitte erklären Sie, warum Sie diesen Termin verschieben müssen...';
$lang['appointment_reschedule_reason_required'] = 'Grund für die Verschiebung ist erforderlich';
$lang['appointment_request_reschedule'] = 'Verschiebung anfordern';
$lang['appointment_new_date'] = 'Neues Datum';
$lang['appointment_new_time'] = 'Neue Uhrzeit';
$lang['appointment_reschedule_request_submitted'] = 'Ihre Verschiebungsanfrage wurde eingereicht und wird von unserem Personal geprüft.';
$lang['appointment_cannot_be_rescheduled'] = 'Dieser Termin kann aufgrund seines aktuellen Status nicht verschoben werden.';

$lang['appointment_processing'] = 'Wird verarbeitet...';
$lang['appointment_select_date_first'] = 'Bitte wählen Sie zuerst ein Datum aus';
$lang['appointment_please_select_date_time'] = 'Bitte wählen Sie ein Datum und eine Uhrzeit aus';
$lang['appointment_current_details'] = 'Aktuelle Details';
$lang['appointment_loading_available_times'] = 'Verfügbare Zeiten werden geladen...';
$lang['appointment_no_available_slots'] = 'Keine verfügbaren Slots';
$lang['appointment_no_available_times'] = 'Keine verfügbaren Zeiten';

$lang['appointment_reschedule_requested'] = 'Verschiebung angefordert';
$lang['appointment_reschedule_pending_review'] = 'Ihre Verschiebungsanfrage wird von unserem Personal geprüft.';
$lang['appointment_reschedule_pending_notice'] = 'Ausstehende Verschiebungsanfragen';
$lang['appointment_requested_date'] = 'Angefordertes Datum';
$lang['appointment_requested_time'] = 'Angeforderte Uhrzeit';
$lang['appointment_current_date'] = 'Aktuelles Datum';
$lang['appointment_approve_reschedule'] = 'Verschiebung genehmigen';
$lang['appointment_reject_reschedule'] = 'Verschiebung ablehnen';
$lang['appointment_pending_reschedules'] = 'Ausstehende Verschiebungen';
$lang['appointment_reschedule_approved'] = 'Verschiebung genehmigt';
$lang['appointment_reschedule_rejected'] = 'Verschiebung abgelehnt';
$lang['appointment_cancellation_requested'] = 'Stornierung angefordert';
$lang['appointment_cancellation_pending_review'] = 'Ihre Stornierungsanfrage wird von unserem Personal geprüft.';
$lang['appointment_cancellation_reason'] = 'Stornierungsgrund';
$lang['appointment_cancellation_notes'] = 'Stornierungsnotizen';
$lang['appointment_cancellation_notes_placeholder'] = 'Bitte erklären Sie, warum Sie diesen Termin stornieren möchten...';
$lang['appointment_cancellation_notes_required'] = 'Stornierungsnotizen sind erforderlich';
$lang['appointment_cancellation_request_submitted'] = 'Ihre Stornierungsanfrage wurde eingereicht und wird von unserem Personal geprüft.';
$lang['appointment_confirm_approve_reschedule'] = 'Sind Sie sicher, dass Sie diese Verschiebungsanfrage genehmigen möchten? Dies aktualisiert den Termin auf das neue Datum und die neue Uhrzeit.';
$lang['appointment_reschedule_denial_reason'] = 'Bitte geben Sie einen Grund für die Ablehnung dieser Verschiebungsanfrage an (dies wird an den Kunden gesendet):';
$lang['appointment_reschedule_approved_successfully'] = 'Verschiebungsanfrage wurde genehmigt und der Termin wurde aktualisiert.';
$lang['appointment_reschedule_denied_successfully'] = 'Verschiebungsanfrage wurde abgelehnt und der Kunde wurde benachrichtigt.';
$lang['appointment_reschedule_approval_failed'] = 'Fehler beim Genehmigen der Verschiebungsanfrage. Bitte versuchen Sie es erneut.';
$lang['appointment_reschedule_denial_failed'] = 'Fehler beim Ablehnen der Verschiebungsanfrage. Bitte versuchen Sie es erneut.';
$lang['appointment_client_information'] = 'Kundeninformationen';
$lang['appointment_provider_information'] = 'Anbieterinformationen';
$lang['appointment_reschedule_action_required'] = 'Aktion erforderlich';
$lang['appointment_reschedule_instructions'] = 'Wenn Kunden Verschiebungen anfordern, erscheinen diese hier zur Genehmigung. Die Genehmigung aktualisiert den Termin automatisch und benachrichtigt den Kunden per E-Mail.';
$lang['appointment_no_pending_reschedules'] = 'Keine ausstehenden Verschiebungsanfragen gefunden.';
$lang['appointment_reschedule_request_details'] = 'Details der Verschiebungsanfrage';
$lang['appointment_reschedule_date_required'] = 'Neues Datum ist erforderlich';
$lang['appointment_reschedule_time_required'] = 'Neue Uhrzeit ist erforderlich';
$lang['appointment_reschedule_future_datetime'] = 'Bitte wählen Sie ein zukünftiges Datum und eine zukünftige Uhrzeit aus';
$lang['appointment_reschedule_request_subject'] = 'Termin-Verschiebungsanfrage';
$lang['appointment_reschedule_approved_subject'] = 'Termin-Verschiebung genehmigt';
$lang['appointment_reschedule_denied_subject'] = 'Termin-Verschiebung abgelehnt';
$lang['appointment_book_again'] = 'Erneut buchen';
$lang['appointment_cancelled_title'] = 'Dieser Termin wurde storniert';
$lang['appointment_book_new_appointment'] = 'Möchten Sie einen neuen Termin buchen?';
$lang['appointment_book_new'] = 'Neuen Termin buchen';
$lang['appointment_deny_reschedule'] = 'Verschiebung ablehnen';
$lang['appointment_reschedule_denial_reason_prompt'] = 'Bitte geben Sie einen Grund für die Ablehnung dieser Verschiebungsanfrage an:';
$lang['appointment_reschedule_denial_reason_required'] = 'Ein Grund für die Ablehnung ist erforderlich';
$lang['appointment_confirm_approve_cancellation'] = 'Sind Sie sicher, dass Sie diese Stornierungsanfrage genehmigen möchten? Dies storniert den Termin dauerhaft.';
$lang['appointment_cancelled_book_again_message'] = 'Dieser Termin wurde storniert. Möchten Sie einen neuen Termin buchen?';
$lang['appointment_no_show_book_again_message'] = 'Dieser Termin war ein Nichterscheinen. Möchten Sie einen neuen Termin buchen?';

// Calendar Integration Removal
$lang['appointment_remove_google_integration'] = 'Google Kalender-Integration entfernen';
$lang['appointment_remove_outlook_integration'] = 'Outlook Kalender-Integration entfernen';
$lang['appointment_confirm_remove_google_integration'] = 'Sind Sie sicher, dass Sie die Google Kalender-Integration von diesem Termin entfernen möchten? Dies löscht das Ereignis auch aus Google Kalender, falls möglich.';
$lang['appointment_confirm_remove_outlook_integration'] = 'Sind Sie sicher, dass Sie die Outlook Kalender-Integration von diesem Termin entfernen möchten? Dies löscht das Ereignis auch aus Outlook Kalender, falls möglich.';
$lang['appointment_google_integration_removed'] = 'Google Kalender-Integration vom Termin entfernt';
$lang['appointment_google_integration_removed_and_deleted'] = 'Google Kalender-Integration entfernt und Ereignis aus Google Kalender gelöscht';
$lang['appointment_google_removal_failed'] = 'Fehler beim Entfernen der Google Kalender-Integration';
$lang['appointment_outlook_integration_removed'] = 'Outlook Kalender-Integration vom Termin entfernt';
$lang['appointment_outlook_integration_removed_and_deleted'] = 'Outlook Kalender-Integration entfernt und Ereignis aus Outlook Kalender gelöscht';
$lang['appointment_outlook_removal_failed'] = 'Fehler beim Entfernen der Outlook Kalender-Integration';
$lang['appointment_missing_required_fields'] = 'Fehlende Pflichtfelder';
$lang['appointment_not_found'] = 'Termin nicht gefunden';
$lang['appointment_outlook_not_authenticated_warning'] = 'Warnung: Sie sind derzeit nicht bei Outlook authentifiziert. Die Integration wird nur lokal entfernt, das Ereignis bleibt jedoch in Ihrem Outlook-Kalender.';
$lang['appointment_outlook_not_available_warning'] = 'Warnung: Outlook-Integration ist nicht verfügbar. Die Integration wird nur lokal entfernt.';
$lang['appointment_outlook_integration_removed_local_only'] = 'Outlook Kalender-Integration lokal entfernt. Hinweis: Das Ereignis kann weiterhin in Ihrem Outlook-Kalender existieren.';

// Dashboard Widgets
$lang['appointly_upcoming_appointments'] = 'Bevorstehende Termine';
$lang['appointly_no_upcoming_appointments'] = 'Keine bevorstehenden Termine';
$lang['appointly_no_appointments_in_range'] = 'Keine Termine im Bereich %s geplant';
$lang['appointly_next_7_days'] = 'Nächste 7 Tage';
$lang['appointly_next_14_days'] = 'Nächste 14 Tage';
$lang['appointly_next_30_days'] = 'Nächste 30 Tage';
$lang['appointly_next_4_weeks'] = 'Nächste 4 Wochen';
$lang['appointly_view_all_appointments'] = 'Alle Termine anzeigen';
$lang['appointly_dashboard_widgets_settings'] = 'Dashboard-Widget-Einstellungen';
$lang['appointly_today_widget_enabled'] = 'Widget für heutige Termine im Dashboard anzeigen';
$lang['appointly_upcoming_widget_enabled'] = 'Widget für bevorstehende Termine im Dashboard anzeigen';
$lang['appointly_upcoming_widget_range'] = 'Datumsbereich des Widgets für bevorstehende Termine';
$lang['appointly_tomorrow'] = 'Morgen';
$lang['days'] = 'Tage';

$lang['appointly_invoice_default_vat'] = 'Standard-Mehrwertsteuer/Steuerprozentsatz';
$lang['appointly_invoice_vat_help'] = 'Standard-Steuerprozentsatz, der auf automatisch generierte Rechnungen angewendet wird (auf 0 setzen für keine Steuer)';
$lang['appointly_invoice_tax_type_help'] = 'Wählen Sie, wie Sie Steuern auf Terminrechnungen anwenden möchten';
$lang['appointly_invoice_tax_type_label'] = 'Steueranwendungsmethode';
$lang['appointly_tax_type_none'] = 'Keine Steuer';
$lang['appointly_tax_type_custom'] = 'Benutzerdefinierter Prozentsatz';
$lang['appointly_tax_type_system'] = 'CRM-Steuersätze verwenden';
$lang['appointly_default_vat_label'] = 'Benutzerdefinierter Steuerprozentsatz';
$lang['appointly_default_vat_help'] = 'Benutzerdefinierter Steuerprozentsatz, der auf Rechnungen angewendet wird (auf 0 setzen für keine Steuer)';
$lang['appointly_system_tax_label'] = 'Steuersatz auswählen';
$lang['appointly_system_tax_help'] = 'Wählen Sie aus Ihren konfigurierten Steuersätzen im CRM';

// Enhanced Invoice Settings - Tab Names
$lang['appointly_invoice_settings'] = 'Rechnung & Steuern';
$lang['appointly_tax_settings'] = 'Steuerkonfiguration';
$lang['appointly_tax_settings_help'] = 'Konfigurieren Sie, wie Steuern auf Rechnungen angewendet werden, die aus Terminen erstellt wurden. Sie können das Steuersystem des CRM verwenden oder einen benutzerdefinierten Prozentsatz festlegen.';
$lang['appointly_tax_type_label'] = 'Steueranwendungsmethode';
$lang['appointly_tax_type_help'] = 'Wählen Sie, wie Sie Steuern auf Terminrechnungen anwenden möchten';

// Form Field Labels
$lang['appointly_enable'] = 'Aktivieren';
$lang['appointly_disable'] = 'Deaktivieren';
$lang['appointly_yes'] = 'Ja';
$lang['appointly_no'] = 'Nein';

// Client Dashboard Language Strings
$lang['appointment_client_dashboard_description'] = 'Verwalten Sie Ihre Termine, zeigen Sie den Verlauf an und buchen Sie neue Termine.';
$lang['appointment_all'] = 'Alle';
$lang['appointment_total_appointments'] = 'Gesamtzahl der Termine';
$lang['appointment_completed_appointments'] = 'Abgeschlossen';
$lang['appointment_upcoming_appointments'] = 'Bevorstehend';
$lang['appointment_cancelled_appointments'] = 'Storniert';
$lang['appointment_no_appointments_found'] = 'Keine Termine gefunden';
$lang['appointment_no_appointments_match_filter'] = 'Keine Termine entsprechen dem aktuellen Filter';
$lang['appointment_details'] = 'Termindetails';
$lang['view_invoice'] = 'Rechnung anzeigen';

// Cancel and Reschedule
$lang['appointment_cancel_reason'] = 'Stornierungsgrund';
$lang['appointment_cancel_reason_placeholder'] = 'Bitte geben Sie einen Grund für die Stornierung dieses Termins an...';
$lang['appointment_cancel_request_sent'] = 'Stornierungsanfrage wurde an das Personal zur Genehmigung gesendet.';
$lang['appointment_cancel_request_failed'] = 'Fehler beim Senden der Stornierungsanfrage. Bitte versuchen Sie es erneut.';
$lang['appointment_reschedule_request_sent'] = 'Verschiebungsanfrage wurde an das Personal zur Genehmigung gesendet.';

// ICS Calendar Export
$lang['appointment_download_ics'] = '.ics-Datei herunterladen';
$lang['appointment_ics_description'] = 'Laden Sie diesen Termin als Kalenderdatei (.ics) herunter, um ihn in jede Kalenderanwendung zu importieren (Apple Calendar, Google Calendar, Outlook, etc.)';
$lang['appointment_calendar_file'] = 'Kalenderdatei';
$lang['appointment_ics_tooltip'] = 'Eine Standard-Kalenderdatei herunterladen, die mit allen Kalenderanwendungen funktioniert';
$lang['appointment_ics_file_downloaded'] = 'Kalenderdatei erfolgreich heruntergeladen';
$lang['appointment_ics_download_error'] = 'Fehler beim Herunterladen der Kalenderdatei';
$lang['appointment_reschedule_request_failed'] = 'Fehler beim Senden der Verschiebungsanfrage. Bitte versuchen Sie es erneut.';
$lang['appointment_client_dashboard'] = 'Kunden-Dashboard';
$lang['appointment_available_times'] = 'Verfügbare Zeiten';
$lang['appointment_error_loading_times'] = 'Fehler beim Laden der Zeiten';
$lang['appointment_cancel_request_submitted'] = 'Stornierungsanfrage erfolgreich eingereicht';
$lang['appointment_date_time_required'] = 'Datum und Uhrzeit sind erforderlich';
$lang['appointment_reschedule_pending'] = 'Verschiebungsanfrage ausstehend';
$lang['appointly_invoice_payment_mode_changed'] = 'Rechnungszahlungsmodus geändert, bitte speichern Sie die Einstellungen, um Änderungen zu übernehmen';
$lang['payment_received_for_appointment'] = 'Zahlung erhalten für:';
$lang['appointly_create_invoice_when_completed'] = 'Rechnung erstellen, wenn Termin gebucht ist?';
$lang['invoice_created_for_appointment'] = 'Rechnung #%s wurde für diesen Termin erstellt.';
$lang['appointment_email_sent_success'] = 'E-Mail erfolgreich gesendet';
$lang['appointment_email_sent_failed'] = 'E-Mail-Versand fehlgeschlagen';
$lang['customer_permission_appointments'] = 'Termine';
$lang['appointment_contact_relationship'] = 'Kontakt & Beziehungsinformationen';
$lang['appointment_download_ics_tooltip'] = 'Kalenderdatei (.ics) herunterladen, um diesen Termin zu Ihrer Kalenderanwendung hinzuzufügen';
$lang['appointment_security_verification'] = 'Sicherheitsverifizierung';
$lang['appointment_view_on_map'] = 'Auf Karte anzeigen';
$lang['appointment_no_notes_available'] = 'Keine Notizen für diesen Termin verfügbar';
$lang['appointment_session_overview'] = 'Sitzungsübersicht';
$lang['appointly_show_staff_email_booking_form'] = 'E-Mail-Adressen des Mitarbeiters im Buchungsformular anzeigen';
$lang['appointly_show_staff_phone_booking_form'] = 'Telefonnummern des Personals im Buchungsformular anzeigen';
$lang['appointly_no_available_time_slots'] = 'Keine Zeitfenster verfügbar';
$lang['appointment_status_changed_successfully'] = 'Terminstatus erfolgreich geändert';
$lang['appointment_status_change_failed'] = 'Fehler beim Ändern des Terminstatus';
// Languages dropdown in external form
$lang['appointments_external_form_show_language_dropdown'] = 'Sprachauswahl anzeigen';
$lang['appointments_external_form_show_language_dropdown_help'] = 'Aktivieren Sie dies, um eine Sprachauswahl auf dem externen Buchungsformular anzuzeigen, damit Kunden zwischen Sprachen wechseln können';

// Recurring appointments UI
$lang['recurring_appointment'] = 'Wiederkehrender Termin';
$lang['recurring'] = 'Wiederkehrend';
$lang['recurring_every'] = 'Alle';
$lang['recurring_day'] = 'Tag(e)';
$lang['recurring_week'] = 'Woche(n)';
$lang['recurring_month'] = 'Monat(e)';
$lang['recurring_year'] = 'Jahr(e)';
$lang['stop_recurring'] = 'Wiederholung Stoppen';
$lang['stop_recurring_confirm'] = 'Sind Sie sicher, dass Sie diesen wiederkehrenden Termin stoppen möchten? Es werden keine neuen Instanzen mehr erstellt.';
$lang['recurring_stopped_successfully'] = 'Wiederkehrende Termine erfolgreich gestoppt';
$lang['edit_recurring_settings'] = 'Wiederholungseinstellungen Bearbeiten';
$lang['error_occurred'] = 'Ein Fehler ist aufgetreten. Bitte versuchen Sie es erneut.';
