<?php

defined('BASEPATH') or exit('No direct script access allowed');

return App_table::find('landlords')
    ->outputUsing(function ($params) {
        extract($params);

        $this->ci->db->query("SET sql_mode = ''");

        $aColumns = [
            '1',
            'landlordid',
            'client_id',
            'first_name',
            'last_name',
            'phone_number',
            'email',
            'created_at',
        ];

        $sIndexColumn = 'landlordid';
        $sTable = db_prefix() . 'tjm_landlords';
        $where = [];

        if ($filtersWhere = $this->getWhereFromRules()) {
            $where[] = $filtersWhere;
        }

        $aColumns = hooks()->apply_filters('landlords_table_sql_columns', $aColumns);

        $result = data_tables_init($aColumns, $sIndexColumn, $sTable, [], $where);

        $output = $result['output'];
        $rResult = $result['rResult'];

        foreach ($rResult as $aRow) {
            $row = [];
            // Bulk actions
            $row[] = '<div class="checkbox"><input type="checkbox" value="' . $aRow['landlordid'] . '"><label></label></div>';
            // landlord id
            $row[] = $aRow['landlordid'];

            // Name
            $name = e($aRow['first_name'] . ' ' . $aRow['last_name']);

            $view_url = admin_url('trade_job_management/landlords/show/' . $aRow['landlordid']);

            $name = '<a href="' . $view_url . '">' . $name . '</a>';

            $name .= '<div class="row-options">';
            $name .= '<a href="' . admin_url('trade_job_management/landlords/show/' . $aRow['landlordid']) . '">' . _l('view') . '</a>';
            if ($aRow['client_id']) {
                $name .= ' | <a href="' . admin_url('clients/client/' . $aRow['client_id']) . '">' . _l('client') . '</a>';
            }
            $name .= ' | <a href="' . admin_url('trade_job_management/landlords/delete/' . $aRow['landlordid']) . '" class="text-danger _delete">' . _l('delete') . '</a>';
            $name .= '</div>';

            $row[] = $name;

            // Primary contact email
            $row[] = !empty($aRow['email']) ? '<a href="mailto:' . e($aRow['email']) . '">' . e($aRow['email']) . '</a>' : '';

            // Primary contact phone
            $row[] = $aRow['phone_number'] ? '<a href="tel:' . e($aRow['phone_number']) . '">' . e($aRow['phone_number']) . '</a>' : '';

            $created_date = $aRow['created_at'];
            $created_date = DateTime::createFromFormat('Y-m-d H:i:s', $created_date);

            $row[] = e($created_date->format('d-m-Y g:ia'));

            $row['DT_RowClass'] = 'has-row-options';
            $row = hooks()->apply_filters('landlords_table_row_data', $row, $aRow);

            $output['aaData'][] = $row;
        }

        return $output;
    })
    ->setRules([]);
