<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper" class="customer_profile">
    <div class="content">
        <div class="row">
            <div class="tw-mt-12 sm:tw-mt-0 col-md-8 col-md-offset-2">
                <div class="panel_s">
                    <div class="panel-body">
                        <div>
                            <div class="tab-content">
                                <div class="row">
									<?php echo
    
									form_open($this->uri->uri_string(), ['class' => 'client-form', 'autocomplete' => 'off', 'id' => 'create_landlord'])

									; ?>
                                    <div class="col-md-12">
                                        <div class="tab-content mtop15">
                                            <div role="tabpanel" class="tab-pane active" id="contact_info">
                                                <h4 class="mbot25"><?php echo _l('landlord_new') ?></h4>
                                                <div class="row">
                                                    <div class="col-md-12">
														<?php $atts = ['required' => true]; ?>
														<?php echo render_input('first_name', 'landlord_firstname', '', 'text', $atts); ?>
														<?php echo render_input('last_name', 'landlord_lastname', '', 'text', $atts); ?>
														<?php echo render_input('phone_number', 'landlord_phone', '', 'text', $atts); ?>
														<?php echo render_input('email', 'landlord_email', '', 'email', $atts); ?>
														<?php echo render_input('website', 'client_website', '', 'url'); ?>
                                                        <hr/>
														<?php $value = isset($client) ? $client->address : ''; ?>
														<?php echo render_textarea('address', 'client_address', $value); ?>
														<?php $value = isset($client) ? $client->city : ''; ?>
														<?php echo render_input('city', 'client_city', $value); ?>
														<?php $value = isset($client) ? $client->state : ''; ?>
														<?php echo render_input('state', 'client_state', $value); ?>
														<?php $value = isset($client) ? $client->zip : ''; ?>
														<?php echo render_input('zip_code', 'client_postal_code', $value); ?>
														<?php $countries = get_all_countries();



														$customer_default_country = get_option('customer_default_country');



														$selected = isset($client) ? $client->country : $customer_default_country;



														echo
    
														render_select('country', $countries, ['country_id', ['short_name']], 'clients_country', $selected, ['data-none-selected-text' => _l('dropdown_non_selected_tex')])

														;



														?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel-footer text-right tw-space-x-1 tw-bg-white" id="profile-save-section">
                                        <button type="submit" data-loading-text="<?php echo _l('wait_text'); ?>"
                                                data-form="#create_landlord"
                                                class="btn btn-primary only-save customer-form-submiter">
			                                <?php echo _l('submit'); ?>
                                        </button>
                                    </div>
									<?php echo form_close(); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

    </div>
</div>
<?php init_tail(); ?>
<script>

    window.addEventListener('load', function () {
        console.log('okay')
        var vRules = vRules = {
            first_name: 'required',
            last_name: 'required',
            phone_number: 'required',
            email: 'required',
        }
        appValidateForm($('#create_landlord'), vRules, submitFormHandler);

        function submitFormHandler(form) {
            form.submit();
        }
    });

</script>
<?php $this->load->view('admin/clients/client_js'); ?>
</body>

</html>
