<?php

defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row _buttons tw-mb-2 sm:tw-mb-4">
            <div class="col-md-8">
				<?php
				if (staff_can('create', 'tasks'))
				{ ?>
                    <a href="#" onclick="new_job(<?php
					if ($this->input->get('property_id'))
					{
						echo "'".admin_url('trade_job_management/jobs/create?rel_id='.$this->input->get('property_id').'&rel_type=property')."'";
					} ?>); return false;" class="btn btn-primary pull-left new">
                        <i class="fa-regular fa-plus tw-mr-1"></i>
						<?php
						echo _l('new_job'); ?>
                    </a>
					<?php
				} ?>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
						<?php
						$this->load->view('jobs/partials/_summary', ['table' => '.table-jobs']); ?>
                        <a href="#" data-toggle="modal" data-target="#tasks_bulk_actions"
                           class="hide bulk-actions-btn table-btn"
                           data-table=".table-jobs"><?php
							echo _l('bulk_actions'); ?></a>
                        <div class="panel-table-full">
							<?php
							$this->load->view('jobs/table_html', ['bulk_actions' => TRUE]); ?>
                        </div>
						<?php
						$this->load->view('jobs/partials/_bulk_actions'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
init_tail(); ?>
<script>
    let willShowJobId = '<?php echo e($jobid); ?>';
    $(function () {
        initDataTable('.table-jobs', admin_url + 'trade_job_management/jobs/table', undefined, undefined, {}, [5, 'asc']);
    });

    if (willShowJobId.length) {
        init_job_modal(willShowJobId)
    }

    // Init task modal and get data from server
    function init_job_modal(task_id, comment_id) {
        var queryStr = "";
        var $leadModal = $("#lead-modal");
        var $taskAddEditModal = $("#_task_modal");
        if ($leadModal.is(":visible")) {
            queryStr +=
                "?opened_from_lead_id=" + $leadModal.find('input[name="leadid"]').val();
            $leadModal.modal("hide");
        } else if ($taskAddEditModal.attr("data-lead-id") !== undefined) {
            queryStr +=
                "?opened_from_lead_id=" + $taskAddEditModal.attr("data-lead-id");
        }

        requestGet("trade_job_management/jobs/get_job_data/" + task_id + queryStr)
            .done(function (response) {
                _job_append_html(response);
                if (typeof comment_id != "undefined") {
                    setTimeout(function () {
                        $('[data-task-comment-href-id="' + comment_id + '"]').click();
                    }, 1000);
                }
            })
            .fail(function (data) {
                $("#job-modal").modal("hide");
                alert_float("danger", data.responseText);
            });
    }


    // General function to append task html returned from request
    function _job_append_html(html) {
        var $jobModal = $("#job-modal");
        if (!$jobModal.length) {  // Kiểm tra đúng cách với jQuery
            return;
        }

        $jobModal.find(".data").html(html);
        setTimeout(function () {
            $jobModal.modal("show");
            fix_task_modal_left_col_height();
            if (is_mobile()) {
                init_new_job_comment(true);
            }
        }, 150);
    }


    // Go to edit view
    function edit_job(job_id) {
        requestGet("trade_job_management/jobs/edit/" + job_id).done(function (response) {
            $("#_task").html(response);
            $("#job-modal").modal("hide");
            $("body").find("#_task_modal").modal({
                show: true,
                backdrop: "static",
            });
        });
    }

    // Mark job status
    function job_mark_as(status, job_id, url) {
        url = typeof url == "undefined" ? "trade_job_management/jobs/mark_as/" + status + "/" + job_id : url;
        var jobModalVisible = $("#job-modal").is(":visible");
        url += "?single_job=" + jobModalVisible;
        $("body").append('<div class="dt-loader"></div>');
        requestGetJSON(url).done(function (response) {
            $("body").find(".dt-loader").remove();
            if (response.success === true || response.success == "true") {
                reload_jobs_tables();
                if (jobModalVisible) {
                    _job_append_html(response.jobHtml);
                }
                alert_float("success", response.message);
            } else if (response.message){
                alert_float("danger", response.message);
            }
        });
    }

    function reload_jobs_tables() {
        $(".table-jobs").DataTable().ajax.reload(null, false);
    }

    // New job function, various actions performed
    function new_job(url) {
        url = typeof url != "undefined" ? url : admin_url + "trade_job_management/jobs/create";

        var $taskSingleModal = $("#job-modal");
        if ($taskSingleModal.is(":visible")) {
            $taskSingleModal.modal("hide");
        }

        var $taskEditModal = $("#_task_modal");
        if ($taskEditModal.is(":visible")) {
            $taskEditModal.modal("hide");
        }

        requestGet(url)
            .done(function (response) {
                $("#_task").html(response);
                $("body").find("#_task_modal").modal({
                    show: true,
                    backdrop: "static",
                });
            })
            .fail(function (error) {
                alert_float("danger", error.responseText);
            });
    }


    // Action for task timer start/stop
    function job_timer_action(e, job_id, timer_id, adminStop) {
        timer_id = typeof timer_id == "undefined" ? "" : timer_id;

        var $timerSelectTask = $("#timer-select-task");
        if (job_id === "" && $timerSelectTask.is(":visible")) {
            return;
        }
        if (timer_id !== "" && job_id == "0") {
            var popupData = {};
            popupData.content = "";
            popupData.content += '<div class="row">';
            popupData.content += '<div class="form-group">';
            if (app.options.has_permission_create_task == "1") {
                popupData.content +=
                    '<div class="input-group" style="margin:0 auto;width:60%;">';
            }
            popupData.content +=
                '<select id="timer_add_job_id" data-empty-title="' +
                app.lang.search_tasks +
                '" data-width="60%" class="ajax-search" data-live-search="true">';
            popupData.content += "</select>";
            if (app.options.has_permission_create_task == "1") {
                popupData.content +=
                    '<div class="input-group-addon" style="opacity: 1;">';
                popupData.content +=
                    '<a href="#" onclick="new_task(\'tasks/task\',' +
                    timer_id +
                    '); return false;"><i class="fa fa-plus"></i></a>';
                popupData.content += "</div>";
            }
            popupData.content += "</div></div>";
            popupData.content += '<div class="form-group">';
            popupData.content +=
                '<textarea id="timesheet_note" placeholder="' +
                app.lang.note +
                '" style="margin:0 auto;width:60%;" rows="4" class="form-control"></textarea>';
            popupData.content += "</div>";
            popupData.content += '<div class="form-group" app-field-wrapper="cost">';
            popupData.content += '<label for="cost" class="control-label">' + app.lang.timesheet_cost + '</label>';
            popupData.content += '<input type="number" id="cost" name="cost" class="form-control" step="0.1" value="0">';
            popupData.content += '</div>';
            popupData.content +=
                "<button type='button' onclick='job_timer_action(this,document.getElementById(\"timer_add_job_id\").value," +
                timer_id +
                ");return false;' class='btn btn-primary'>" +
                app.lang.confirm +
                "</button>";
            popupData.message = app.lang.task_stop_timer;
            var $popupHTML = system_popup(popupData);
            $popupHTML.attr("id", "timer-select-task");
            init_ajax_search(
                "tasks",
                "#timer_add_job_id",
                undefined,
                admin_url + "tasks/ajax_search_assign_task_to_timer"
            );
            return false;
        }

        $(e).addClass("disabled");

        const data = {
            job_id: job_id,
            timer_id: timer_id
        };
        data.note = $("body").find("#timesheet_note").val();
        if (!data.note) {
            data.note = "";
        }

        data.cost = $("body").find("#timesheet_cost").val();
        if (!data.cost) {
            data.cost = 0;
        }
        const jobModalVisible = $("#job-modal").is(":visible");
        let reqUrl = admin_url + "trade_job_management/jobs/timer_tracking?single_task=" + jobModalVisible;
        if (adminStop) {
            reqUrl += "&admin_stop=" + adminStop;
        }
        $.post(reqUrl, data).done(function (response) {
            response = JSON.parse(response);

            // Timer action, stopping from staff/member/id
            if ($("body").hasClass("member")) {
                window.location.reload();
            }

            if (jobModalVisible) {
                _job_append_html(response.taskHtml);
            }

            if ($timerSelectTask.is(":visible")) {
                $timerSelectTask.find(".system-popup-close").click();
            }

            _init_timers_top_html(JSON.parse(response.timers));

            $(".popover-top-timer-note").popover("hide");
            reload_jobs_tables();
        });
    }

    // New timesheet add manually from task single modal
    $("body").on("click", ".job-single-add-timesheet", function (e) {
        e.preventDefault();

        var start_time_input = $("body").find(
            '#job-modal input[name="timesheet_start_time"]'
        );
        var end_time_input = $("body").find(
            '#job-modal input[name="timesheet_end_time"]'
        );

        var start_time = start_time_input.val();
        var end_time = end_time_input.val();

        start_time === "" &&
        start_time_input.parents(".form-group").addClass("has-error");
        end_time === "" &&
        end_time_input.parents(".form-group").addClass("has-error");

        if (start_time !== "" && end_time !== "") {
            var data = {};
            data.start_time = start_time;
            data.end_time = end_time;
            data.job_id = $(this).data("job-id");
            data.note = $("body").find("#timesheet_note").val();
            data.cost = $("body").find("#timesheet_cost").val();
            data.staff_id = $("body").find('select[name="timesheet_staff_id"]').val();
            $.post(admin_url + "trade_job_management/jobs/log_time", data).done(function (response) {
                response = JSON.parse(response);
                if (response.success === true || response.success === "true") {
                    console.log(data);
                    console.log('here')
                    init_job_modal(data.job_id);
                    alert_float("success", response.message);
                    setTimeout(function () {
                        reload_jobs_tables();
                        init_job_timers();
                    }, 20);
                } else {
                    alert_float("warning", response.message);
                }
            });
        }
    });

    // Delete job timesheet from the job single modal
    $("body").on("click", ".job-single-delete-timesheet", function (e) {
        e.preventDefault();
        if (confirm_delete()) {
            var _delete_timesheet_job_id = $(this).data("job-id");
            requestGet($(this).attr("href")).done(function (response) {
                init_job_modal(_delete_timesheet_job_id);
                console.log(_delete_timesheet_job_id);
                setTimeout(function () {
                    reload_jobs_tables();
                    init_job_timers();
                }, 20);
            });
        }
    });


    // Fetches all staff timers and append to DOM
    function init_job_timers() {
        requestGetJSON("trade_job_management/jobs/get_staff_started_timers").done(function (response) {
            _init_timers_top_html(response);
        });
    }

</script>
</body>

</html>
