<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_146 extends App_module_migration {

	protected $module_name = 'trade_job_management';
	protected int $version = 146;

	public function up()
	{
		zegaware_add_migration_log($this->module_name, $this->version);
		if ( ! $this->ci->db->field_exists('job_hash', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs ADD COLUMN `job_hash` VARCHAR(64)');
		}
		if ( ! $this->ci->db->field_exists('confirmation_firstname', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs ADD COLUMN `confirmation_firstname` VARCHAR(64)');
		}
		if ( ! $this->ci->db->field_exists('confirmation_lastname', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs ADD COLUMN `confirmation_lastname` VARCHAR(64)');
		}
		if ( ! $this->ci->db->field_exists('confirmation_email', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs ADD COLUMN `confirmation_email` VARCHAR(64)');
		}
		if ( ! $this->ci->db->field_exists('confirmation_feedback', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs ADD COLUMN `confirmation_feedback` TEXT');
		}
		if ( ! $this->ci->db->field_exists('confirmation_signed', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs ADD COLUMN `confirmation_signed` TINYINT(1)');
		}
		if ( ! $this->ci->db->field_exists('confirmation_at', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs ADD COLUMN `confirmation_at` DATETIME');
		}
		if ( ! $this->ci->db->field_exists('signature_path', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs ADD COLUMN `signature_path` VARCHAR(64)');
		}

		/** @var array $rows */
		$this->ci->db->where('job_hash', NULL);
		$rows = $this->ci->db->get(db_prefix().'tjm_jobs')->result_array();
		if ( ! empty($rows))
		{
			foreach ($rows as $row)
			{
				$job_hash = generate_job_hash($row);

				$this->ci->db->where('jobid', $row['jobid']);
				$this->ci->db->update(db_prefix().'tjm_jobs', [
					'job_hash' => $job_hash,
				]);
			}
		}
	}

	public function down()
	{
		zegaware_delete_migration_log($this->module_name, $this->version);
		if ($this->ci->db->field_exists('job_hash', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs DROP COLUMN `job_hash`');
		}
		if ($this->ci->db->field_exists('confirmation_firstname', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs DROP COLUMN `confirmation_firstname`');
		}
		if ($this->ci->db->field_exists('confirmation_lastname', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs DROP COLUMN `confirmation_lastname`');
		}
		if ($this->ci->db->field_exists('confirmation_email', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs DROP COLUMN `confirmation_email`');
		}
		if ($this->ci->db->field_exists('confirmation_feedback', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs DROP COLUMN `confirmation_feedback`');
		}
		if ($this->ci->db->field_exists('confirmation_signed', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs DROP COLUMN `confirmation_signed`');
		}
		if ($this->ci->db->field_exists('confirmation_at', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs DROP COLUMN `confirmation_at`');
		}
		if ($this->ci->db->field_exists('signature_path', db_prefix().'tjm_jobs'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_jobs DROP COLUMN `signature_path`');
		}
	}

}
