<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_108 extends App_module_migration {

	protected $module_name = 'trade_job_management';
	protected int $version = 108;

	public function up()
	{
		if ( ! $this->ci->db->field_exists('email', db_prefix().'clients'))
		{
			$this->ci->db->query('ALTER TABLE `'.db_prefix().'clients` ADD `email` TEXT NULL AFTER `company`');
		}

		if ( ! $this->ci->db->field_exists('datevisit', db_prefix().'tasks'))
		{
			$this->ci->db->query('ALTER TABLE `'.db_prefix().'tasks` ADD `datevisit` DATETIME NULL AFTER `startdate`');
		}

		$this->ci->db->query(
			'CREATE TABLE IF NOT EXISTS `'.db_prefix().'jobs_scheduled_logs` (
		      `id` int(11) NOT NULL AUTO_INCREMENT,
		      `job_id` int(11) NOT NULL,
		      `old_scheduled_time` DATETIME NULL,
		      `new_scheduled_time` DATETIME NOT NULL,
		      `staff_id` int(11) NOT NULL,
		      `created_at` DATETIME NOT NULL,
		      PRIMARY KEY (`id`),
            FOREIGN KEY (`staff_id`) REFERENCES `'.db_prefix().'staff`(`staffid`) ON DELETE CASCADE
	      ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4  COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;',
		);

		$this->ci->db->query(
			'CREATE TABLE IF NOT EXISTS `'.db_prefix().'jobs_status_logs` (
		      `id` int(11) NOT NULL AUTO_INCREMENT,
		      `job_id` int(11) NOT NULL,
		      `old_status` int(1) NOT NULL,
		      `new_status` int(1) NOT NULL,
		      `staff_id` int(11) NOT NULL,
	          `created_at` DATETIME NOT NULL,
		      PRIMARY KEY (`id`),
			FOREIGN KEY (`staff_id`) REFERENCES `'.db_prefix().'staff`(`staffid`) ON DELETE CASCADE
      ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4  COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;',
		);

		zegaware_add_migration_log($this->module_name, $this->version);
	}

	public function down()
	{
		if ($this->ci->db->field_exists('email', db_prefix().'clients'))
		{
			$this->ci->db->query('ALTER TABLE `'.db_prefix().'clients` DROP COLUMN `email`');
		}

		if ($this->ci->db->field_exists('datevisit', db_prefix().'tasks'))
		{
			$this->ci->db->query('ALTER TABLE `'.db_prefix().'tasks` DROP COLUMN `datevisit`');
		}

		$this->ci->db->query('DROP TABLE IF EXISTS `'.db_prefix().'jobs_scheduled_logs`;');

		$this->ci->db->query('DROP TABLE IF EXISTS `'.db_prefix().'jobs_status_logs`;');

		zegaware_delete_migration_log($this->module_name, $this->version);
	}

}
