<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_105 extends App_module_migration
{
    protected $module_name = 'trade_job_management';
    protected int $version = 105;

    public function up()
    {
        if (!$this->ci->db->field_exists('job_type', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` ADD `job_type` INT');
        }

        if (!$this->ci->db->field_exists('job_property_type', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` ADD `job_property_type` VARCHAR(255)');
        }

        if (!$this->ci->db->field_exists('property_address', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` ADD `property_address` VARCHAR(255)');
        }

        if (!$this->ci->db->field_exists('landlord_person_name', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` ADD `landlord_person_name` VARCHAR(255)');
        }

        if (!$this->ci->db->field_exists('landlord_person_phonenumber', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` ADD `landlord_person_phonenumber` VARCHAR(255)');
        }

        if (!$this->ci->db->field_exists('engineer_name', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` ADD `engineer_name` VARCHAR(255)');
        }

        if (!$this->ci->db->field_exists('engineer_phonenumber', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` ADD `engineer_phonenumber` VARCHAR(255)');
        }

        zegaware_add_migration_log($this->module_name, $this->version);
    }

    

    public function down()
    {
        if ($this->ci->db->field_exists('job_type', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` DROP COLUMN `job_type`');
        }
        if ($this->ci->db->field_exists('property_address', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` DROP COLUMN `property_address`');
        }
        if ($this->ci->db->field_exists('job_property_type', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` DROP COLUMN `job_property_type`');
        }
        if ($this->ci->db->field_exists('landlord_person_name', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` DROP COLUMN `landlord_person_name`');
        }
        if ($this->ci->db->field_exists('landlord_person_phonenumber', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` DROP COLUMN `landlord_person_phonenumber`');
        }
        if ($this->ci->db->field_exists('engineer_name', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` DROP COLUMN `engineer_name`');
        }
        if ($this->ci->db->field_exists('engineer_phonenumber', db_prefix() . 'tasks')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'tasks` DROP COLUMN `engineer_phonenumber`');
        }

        zegaware_delete_migration_log($this->module_name, $this->version);
    }

    
}
