<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_104 extends App_module_migration
{
    protected $module_name = 'trade_job_management';
    protected int $version = 104;

    public function up()
    {
        if (!$this->ci->db->field_exists('property_address', db_prefix() . 'projects')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'projects` ADD `property_address` VARCHAR(255)');
        }

        if (!$this->ci->db->field_exists('property_type', db_prefix() . 'projects')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'projects` ADD `property_type` VARCHAR(255)');
        }

        zegaware_add_migration_log($this->module_name, $this->version);
    }

    

    public function down()
    {
        if ($this->ci->db->field_exists('property_address', db_prefix() . 'projects')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'projects` DROP COLUMN `property_address`');
        }

        if ($this->ci->db->field_exists('property_type', db_prefix() . 'projects')) {
            $this->ci->db->query('ALTER TABLE `' . db_prefix() . 'projects` DROP COLUMN `property_type`');
        }

        zegaware_delete_migration_log($this->module_name, $this->version);
    }

    
}
